/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;

public class CacheContainerAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    public static final CacheContainerAdd INSTANCE = new CacheContainerAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        CommonAttributes.DEFAULT_CACHE.validateAndSet(source, target);
        if (source.hasDefined("aliases")) {
            target.get("aliases").set(source.get("aliases"));
        }
        CommonAttributes.JNDI_NAME.validateAndSet(source, target);
        CommonAttributes.START.validateAndSet(source, target);
        CommonAttributes.LISTENER_EXECUTOR.validateAndSet(source, target);
        CommonAttributes.EVICTION_EXECUTOR.validateAndSet(source, target);
        CommonAttributes.REPLICATION_QUEUE_EXECUTOR.validateAndSet(source, target);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CommonAttributes.DEFAULT_CACHE.resolveModelAttribute(context, model);
        String defaultCache = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.START.resolveModelAttribute(context, model);
        String startMode = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiNameString = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.LISTENER_EXECUTOR.resolveModelAttribute(context, model);
        String listenerExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.EVICTION_EXECUTOR.resolveModelAttribute(context, model);
        String evictionExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CommonAttributes.REPLICATION_QUEUE_EXECUTOR.resolveModelAttribute(context, model);
        String replicationQueueExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        boolean hasTransport = model.hasDefined("transport") && model.get("transport").hasDefined("TRANSPORT");
        Transport transportConfig = hasTransport ? new Transport() : null;
        EmbeddedCacheManagerDependencies dependencies = new EmbeddedCacheManagerDependencies(transportConfig);
        ServiceName[] aliases = null;
        if (model.hasDefined("aliases")) {
            List list = operation.get("aliases").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ServiceTarget target = context.getServiceTarget();
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(name);
        ServiceBuilder configBuilder = target.addService(configServiceName, (Service)new EmbeddedCacheManagerConfigurationService(name, defaultCache, dependencies)).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, dependencies.getMBeanServerInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, EmbeddedCacheManagerConfigurationService.getClassLoaderServiceName(name), ClassLoader.class, dependencies.getClassLoaderInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        ServiceController.Mode initialMode = startMode != null ? StartMode.valueOf(startMode).getMode() : ServiceController.Mode.ON_DEMAND;
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(name);
        InjectedValue config = new InjectedValue();
        ServiceBuilder containerBuilder = target.addService(containerServiceName, (Service)new EmbeddedCacheManagerService((Value<EmbeddedCacheManagerConfiguration>)config)).addDependency(configServiceName, EmbeddedCacheManagerConfiguration.class, (Injector)config).addAliases(aliases).setInitialMode(initialMode);
        newControllers.add(containerBuilder.install());
        String jndiName = (jndiNameString != null ? InfinispanJndiName.toJndiName(jndiNameString) : InfinispanJndiName.defaultCacheContainerJndiName(name)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(containerServiceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        newControllers.add(binderBuilder.install());
        if (hasTransport) {
            ModelNode transport = model.get(new String[]{"transport", "TRANSPORT"});
            resolvedValue = CommonAttributes.STACK.resolveModelAttribute(context, transport);
            String stack = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = CommonAttributes.CLUSTER.resolveModelAttribute(context, transport);
            String cluster = resolvedValue.isDefined() ? resolvedValue.asString() : name;
            long lockTimeout = CommonAttributes.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong();
            resolvedValue = CommonAttributes.EXECUTOR.resolveModelAttribute(context, transport);
            String executor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            transportConfig.setLockTimeout(lockTimeout);
            this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, executor, transportConfig.getExecutorInjector());
            ServiceName channelServiceName = ChannelService.getServiceName((String)name);
            configBuilder.addDependency(channelServiceName, Channel.class, transportConfig.getChannelInjector());
            InjectedValue channelFactory = new InjectedValue();
            ServiceBuilder channelBuilder = target.addService(channelServiceName, (Service)new ChannelService(cluster, (Value)channelFactory)).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
            newControllers.add(channelBuilder.install());
        }
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, listenerExecutor, dependencies.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, evictionExecutor, dependencies.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, replicationQueueExecutor, dependencies.getReplicationQueueExecutorInjector());
        newControllers.add(configBuilder.install());
        log.debugf("%s cache container installed", (Object)name);
    }

    private void addExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<Executor> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<ScheduledExecutorService> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, injector);
        }
    }

    static class Transport
    implements EmbeddedCacheManagerConfigurationService.TransportConfiguration {
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        @Override
        public Channel getChannel() {
            return (Channel)this.channel.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }
    }

    static class EmbeddedCacheManagerDependencies
    implements EmbeddedCacheManagerConfigurationService.Dependencies {
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final InjectedValue<ClassLoader> loader = new InjectedValue();
        private final EmbeddedCacheManagerConfigurationService.TransportConfiguration transport;

        EmbeddedCacheManagerDependencies(EmbeddedCacheManagerConfigurationService.TransportConfiguration transport) {
            this.transport = transport;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        Injector<ClassLoader> getClassLoaderInjector() {
            return this.loader;
        }

        @Override
        public EmbeddedCacheManagerConfigurationService.TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }

        @Override
        public ClassLoader getClassLoader() {
            return (ClassLoader)this.loader.getOptionalValue();
        }
    }
}

