/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class InfinispanSubsystemAdd
extends AbstractAddStepHandler {
    public static final InfinispanSubsystemAdd INSTANCE = new InfinispanSubsystemAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        InfinispanSubsystemAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        CommonAttributes.DEFAULT_CACHE_CONTAINER.validateAndSet(source, target);
        target.get("cache-container").setEmptyObject();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        InfinispanSubsystemAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        InfinispanLogger.ROOT_LOGGER.activatingSubsystem();
        ServiceTarget target = context.getServiceTarget();
        String defaultContainer = CommonAttributes.DEFAULT_CACHE_CONTAINER.resolveModelAttribute(context, model).asString();
        InjectedValue container = new InjectedValue();
        ValueService service = new ValueService((Value)container);
        ServiceController controller = target.addService(EmbeddedCacheManagerService.getServiceName(null), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName(defaultContainer), EmbeddedCacheManager.class, (Injector)container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        newControllers.add(controller);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

