/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemAdd;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.TransportAdd;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class InfinispanSubsystemDescribe
implements OperationStepHandler {
    public static final InfinispanSubsystemDescribe INSTANCE = new InfinispanSubsystemDescribe();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        result.add(InfinispanSubsystemAdd.createOperation(rootAddress.toModelNode(), subModel));
        if (subModel.hasDefined("cache-container")) {
            for (Property container : subModel.get("cache-container").asPropertyList()) {
                ModelNode containerAddress = rootAddress.toModelNode();
                containerAddress.add("cache-container", container.getName());
                result.add(CacheContainerAdd.createOperation(containerAddress, container.getValue()));
                this.addCacheContainerConfigCommands(container, containerAddress, result);
                for (Property cacheTypeList : container.getValue().asPropertyList()) {
                    ModelNode cacheAddress;
                    if (cacheTypeList.getName().equals("local-cache")) {
                        for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                            cacheAddress = containerAddress.clone();
                            cacheAddress.add("local-cache", cache.getName());
                            result.add(LocalCacheAdd.createOperation(cacheAddress, cache.getValue()));
                            this.addCacheConfigCommands(cache, cacheAddress, result);
                        }
                        continue;
                    }
                    if (cacheTypeList.getName().equals("invalidation-cache")) {
                        for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                            cacheAddress = containerAddress.clone();
                            cacheAddress.add("invalidation-cache", cache.getName());
                            result.add(InvalidationCacheAdd.createOperation(cacheAddress, cache.getValue()));
                            this.addCacheConfigCommands(cache, cacheAddress, result);
                        }
                        continue;
                    }
                    if (cacheTypeList.getName().equals("replicated-cache")) {
                        for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                            cacheAddress = containerAddress.clone();
                            cacheAddress.add("replicated-cache", cache.getName());
                            result.add(ReplicatedCacheAdd.createOperation(cacheAddress, cache.getValue()));
                            this.addCacheConfigCommands(cache, cacheAddress, result);
                            this.addSharedStateCacheConfigCommands(cache, cacheAddress, result);
                        }
                        continue;
                    }
                    if (!cacheTypeList.getName().equals("distributed-cache")) continue;
                    for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                        cacheAddress = containerAddress.clone();
                        cacheAddress.add("distributed-cache", cache.getName());
                        result.add(DistributedCacheAdd.createOperation(cacheAddress, cache.getValue()));
                        this.addCacheConfigCommands(cache, cacheAddress, result);
                        this.addSharedStateCacheConfigCommands(cache, cacheAddress, result);
                    }
                }
            }
        }
        context.completeStep();
    }

    private void addCacheContainerConfigCommands(Property container, ModelNode address, ModelNode result) throws OperationFailedException {
        if (container.getValue().hasDefined("transport") && container.getValue().get(new String[]{"transport", "TRANSPORT"}).isDefined()) {
            ModelNode transport = container.getValue().get(new String[]{"transport", "TRANSPORT"});
            ModelNode transportAddress = address.clone();
            transportAddress.add("transport", "TRANSPORT");
            result.add(TransportAdd.createOperation(transportAddress, transport));
        }
    }

    private void addCacheConfigCommands(Property cache, ModelNode address, ModelNode result) throws OperationFailedException {
        ModelNode storeAddress;
        ModelNode store;
        if (cache.getValue().get(new String[]{"locking", "LOCKING"}).isDefined()) {
            ModelNode locking = cache.getValue().get(new String[]{"locking", "LOCKING"});
            ModelNode lockingAddress = address.clone();
            lockingAddress.add("locking", "LOCKING");
            result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.LOCKING_ATTRIBUTES, lockingAddress, locking));
        }
        if (cache.getValue().get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            ModelNode transaction = cache.getValue().get(new String[]{"transaction", "TRANSACTION"});
            ModelNode transactionAddress = address.clone();
            transactionAddress.add("transaction", "TRANSACTION");
            result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.TRANSACTION_ATTRIBUTES, transactionAddress, transaction));
        }
        if (cache.getValue().get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            ModelNode eviction = cache.getValue().get(new String[]{"eviction", "EVICTION"});
            ModelNode evictionAddress = address.clone();
            evictionAddress.add("eviction", "EVICTION");
            result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.EVICTION_ATTRIBUTES, evictionAddress, eviction));
        }
        if (cache.getValue().get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = cache.getValue().get(new String[]{"expiration", "EXPIRATION"});
            ModelNode expirationAddress = address.clone();
            expirationAddress.add("expiration", "EXPIRATION");
            result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.EXPIRATION_ATTRIBUTES, expirationAddress, expiration));
        }
        if (cache.getValue().get(new String[]{"store", "STORE"}).isDefined()) {
            store = cache.getValue().get(new String[]{"store", "STORE"});
            storeAddress = address.clone();
            storeAddress.add("store", "STORE");
            result.add(CacheConfigOperationHandlers.createStoreOperation(CommonAttributes.COMMON_STORE_ATTRIBUTES, storeAddress, store, CommonAttributes.STORE_ATTRIBUTES));
            this.addStoreWriteBehindConfigCommands(store, storeAddress, result);
            this.addCacheStorePropertyCommands(store, storeAddress, result);
        } else if (cache.getValue().get(new String[]{"file-store", "FILE_STORE"}).isDefined()) {
            store = cache.getValue().get(new String[]{"file-store", "FILE_STORE"});
            storeAddress = address.clone();
            storeAddress.add("file-store", "FILE_STORE");
            result.add(CacheConfigOperationHandlers.createStoreOperation(CommonAttributes.COMMON_STORE_ATTRIBUTES, storeAddress, store, CommonAttributes.FILE_STORE_ATTRIBUTES));
            this.addStoreWriteBehindConfigCommands(store, storeAddress, result);
            this.addCacheStorePropertyCommands(store, storeAddress, result);
        } else if (cache.getValue().get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"}).isDefined()) {
            store = cache.getValue().get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"});
            storeAddress = address.clone();
            storeAddress.add("string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE");
            result.add(CacheConfigOperationHandlers.createStringKeyedStoreOperation(storeAddress, store));
            this.addStoreWriteBehindConfigCommands(store, storeAddress, result);
            this.addCacheStorePropertyCommands(store, storeAddress, result);
        } else if (cache.getValue().get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"}).isDefined()) {
            store = cache.getValue().get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"});
            storeAddress = address.clone();
            storeAddress.add("binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE");
            result.add(CacheConfigOperationHandlers.createBinaryKeyedStoreOperation(storeAddress, store));
            this.addStoreWriteBehindConfigCommands(store, storeAddress, result);
            this.addCacheStorePropertyCommands(store, storeAddress, result);
        } else if (cache.getValue().get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"}).isDefined()) {
            store = cache.getValue().get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"});
            storeAddress = address.clone();
            storeAddress.add("mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE");
            result.add(CacheConfigOperationHandlers.createMixedKeyedStoreOperation(storeAddress, store));
            this.addStoreWriteBehindConfigCommands(store, storeAddress, result);
            this.addCacheStorePropertyCommands(store, storeAddress, result);
        } else if (cache.getValue().get(new String[]{"remote-store", "REMOTE_STORE"}).isDefined()) {
            store = cache.getValue().get(new String[]{"remote-store", "REMOTE_STORE"});
            storeAddress = address.clone();
            storeAddress.add("remote-store", "REMOTE_STORE");
            result.add(CacheConfigOperationHandlers.createStoreOperation(CommonAttributes.COMMON_STORE_ATTRIBUTES, storeAddress, store, CommonAttributes.REMOTE_STORE_ATTRIBUTES));
            this.addStoreWriteBehindConfigCommands(store, storeAddress, result);
            this.addCacheStorePropertyCommands(store, storeAddress, result);
        }
    }

    private void addSharedStateCacheConfigCommands(Property cache, ModelNode address, ModelNode result) throws OperationFailedException {
        if (cache.getValue().get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.getValue().get(new String[]{"state-transfer", "STATE_TRANSFER"});
            ModelNode stateTransferAddress = address.clone();
            stateTransferAddress.add("state-transfer", "STATE_TRANSFER");
            ModelNode createOperation = CacheConfigOperationHandlers.createOperation(CommonAttributes.STATE_TRANSFER_ATTRIBUTES, stateTransferAddress, stateTransfer);
            result.add(createOperation);
        }
    }

    private void addStoreWriteBehindConfigCommands(ModelNode store, ModelNode address, ModelNode result) throws OperationFailedException {
        if (store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined()) {
            ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
            ModelNode writeBehindAddress = address.clone();
            writeBehindAddress.add("write-behind", "WRITE_BEHIND");
            ModelNode createOperation = CacheConfigOperationHandlers.createOperation(CommonAttributes.WRITE_BEHIND_ATTRIBUTES, writeBehindAddress, writeBehind);
            result.add(createOperation);
        }
    }

    private void addCacheStorePropertyCommands(ModelNode store, ModelNode address, ModelNode result) throws OperationFailedException {
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                ModelNode propertyAddress = address.clone().add("property", property.getName());
                AttributeDefinition[] ATTRIBUTE = new AttributeDefinition[]{CommonAttributes.VALUE};
                result.add(CacheConfigOperationHandlers.createOperation(ATTRIBUTE, propertyAddress, property.getValue()));
            }
        }
    }
}

