/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryManager;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.QLCompiler;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCJBossQLQuery
extends JDBCAbstractQueryCommand {
    public JDBCJBossQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q) {
        super(manager, q);
        JDBCJBossQLQueryMetaData metadata = (JDBCJBossQLQueryMetaData)q;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("JBossQL: " + metadata.getJBossQL()));
        }
        QLCompiler compiler = JDBCQueryManager.getInstance(metadata.getQLCompilerClass(), manager.getCatalog());
        try {
            compiler.compileJBossQL(metadata.getJBossQL(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
        }
        catch (Throwable t) {
            throw new RuntimeException(CmpMessages.MESSAGES.errorCompilingJbossQlStatement(metadata.getJBossQL(), t));
        }
        this.setSQL(compiler.getSQL());
        this.setOffsetParam(compiler.getOffsetParam());
        this.setOffsetValue(compiler.getOffsetValue());
        this.setLimitParam(compiler.getLimitParam());
        this.setLimitValue(compiler.getLimitValue());
        if (compiler.isSelectEntity()) {
            JDBCEntityBridge selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
            this.setSelectEntity(selectEntity);
            JDBCReadAheadMetaData readahead = metadata.getReadAhead();
            if (readahead.isOnFind()) {
                this.setEagerLoadGroup(readahead.getEagerLoadGroup());
                this.setOnFindCMRList(compiler.getLeftJoinCMRList());
                if (compiler.isSelectDistinct()) {
                    boolean[] mask = this.getEagerLoadMask();
                    JDBCCMPFieldBridge[] tableFields = (JDBCCMPFieldBridge[])selectEntity.getTableFields();
                    for (int i = 0; i < tableFields.length; ++i) {
                        if (!mask[i] || tableFields[i].getJDBCType().isSearchable()) continue;
                        mask[i] = false;
                    }
                }
            }
        } else if (compiler.isSelectField()) {
            this.setSelectField((JDBCCMPFieldBridge)compiler.getSelectField());
        } else {
            this.setSelectFunction(compiler.getSelectFunction(), (JDBCStoreManager)compiler.getStoreManager());
        }
        this.setParameterList(compiler.getInputParameters());
    }
}

