/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.RelationPair;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;

public final class RelationData {
    private final JDBCCMRFieldBridge leftCMRField;
    private final JDBCCMRFieldBridge rightCMRField;
    public final Set addedRelations = new HashSet();
    public final Set removedRelations = new HashSet();
    public final Set notRelatedPairs = new HashSet();

    public RelationData(JDBCCMRFieldBridge leftCMRField, JDBCCMRFieldBridge rightCMRField) {
        this.leftCMRField = leftCMRField;
        this.rightCMRField = rightCMRField;
    }

    public JDBCCMRFieldBridge getLeftCMRField() {
        return this.leftCMRField;
    }

    public JDBCCMRFieldBridge getRightCMRField() {
        return this.rightCMRField;
    }

    public void addRelation(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId) {
        if (!leftCMRField.hasForeignKey() && !rightCMRField.hasForeignKey()) {
            RelationPair pair = this.createRelationPair(leftCMRField, leftId, rightCMRField, rightId);
            if (this.removedRelations.contains(pair)) {
                this.removedRelations.remove(pair);
            } else {
                this.addedRelations.add(pair);
                if (this.notRelatedPairs.contains(pair)) {
                    this.notRelatedPairs.remove(pair);
                }
            }
        }
    }

    public void removeRelation(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId) {
        if (!leftCMRField.hasForeignKey() && !rightCMRField.hasForeignKey()) {
            RelationPair pair = this.createRelationPair(leftCMRField, leftId, rightCMRField, rightId);
            if (this.addedRelations.contains(pair)) {
                this.addedRelations.remove(pair);
                this.notRelatedPairs.add(pair);
            } else if (!this.notRelatedPairs.contains(pair)) {
                this.removedRelations.add(pair);
            }
        }
    }

    public boolean isDirty() {
        return this.addedRelations.size() > 0 || this.removedRelations.size() > 0;
    }

    private RelationPair createRelationPair(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId) {
        if (this.leftCMRField == leftCMRField && this.rightCMRField == rightCMRField) {
            return new RelationPair(leftCMRField, leftId, rightCMRField, rightId);
        }
        if (this.leftCMRField == rightCMRField && this.rightCMRField == leftCMRField) {
            return new RelationPair(rightCMRField, rightId, leftCMRField, leftId);
        }
        throw CmpMessages.MESSAGES.cmrFieldsWrongType();
    }
}

