/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementSerializer
extends SerializerSupport {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ElementSerializer.class);
    private static final Logger log = Logger.getLogger(ElementSerializer.class);

    @Override
    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        if (value == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ELEMENT_VALUE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (!(value instanceof Element)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"VALUE_IS_NOT_A_ELEMENT", (Object[])new Object[]{value.getClass().getName()}));
        }
        String xmlFragment = DOMWriter.printNode((Node)((Element)value), (boolean)false);
        return new BufferedStreamResult(xmlFragment);
    }
}

