/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxws.WrapperGenerator;

public abstract class AbstractWrapperGenerator
implements WrapperGenerator {
    private static final ResourceBundle bundle = BundleUtils.getBundle(AbstractWrapperGenerator.class);
    private static Set<String> excludedGetters = new HashSet<String>(4);
    protected ClassLoader loader;

    public AbstractWrapperGenerator(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void reset(ClassLoader loader) {
        this.loader = loader;
    }

    protected SortedMap<String, ExceptionProperty> getExceptionProperties(Class<?> exception) {
        if (!Exception.class.isAssignableFrom(exception)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_AN_EXCEPTION", (Object[])new Object[0]));
        }
        TreeMap<String, ExceptionProperty> sortedGetters = new TreeMap<String, ExceptionProperty>();
        for (Method method : exception.getMethods()) {
            int offset;
            String name;
            Class<?> returnType;
            if (Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()) == Void.TYPE || excludedGetters.contains(name = method.getName())) continue;
            boolean isTransient = method.isAnnotationPresent(XmlTransient.class);
            if (name.startsWith("get")) {
                offset = 3;
            } else {
                if (!name.startsWith("is")) continue;
                offset = 2;
            }
            name = Introspector.decapitalize(name.substring(offset));
            if (!isTransient) {
                try {
                    Field field = exception.getDeclaredField(name);
                    isTransient = field.getAnnotation(XmlTransient.class) != null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            sortedGetters.put(name, new ExceptionProperty(name, returnType, isTransient));
        }
        return sortedGetters;
    }

    static {
        excludedGetters.add("getCause");
        excludedGetters.add("getClass");
        excludedGetters.add("getLocalizedMessage");
        excludedGetters.add("getStackTrace");
    }

    protected class ExceptionProperty {
        private String name;
        private Class<?> returnType;
        private boolean transientAnnotated;

        public ExceptionProperty() {
        }

        public ExceptionProperty(String name, Class<?> returnType, boolean transientAnnotated) {
            this.name = name;
            this.returnType = returnType;
            this.transientAnnotated = transientAnnotated;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Class<?> returnType) {
            this.returnType = returnType;
        }

        public boolean isTransientAnnotated() {
            return this.transientAnnotated;
        }

        public void setTransientAnnotated(boolean transientAnnotated) {
            this.transientAnnotated = transientAnnotated;
        }
    }
}

