/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.server.PortComponentResolver;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;

public class PortComponentLinkServlet
extends HttpServlet {
    private static final ResourceBundle bundle = BundleUtils.getBundle(PortComponentLinkServlet.class);
    private static final Logger log = Logger.getLogger(PortComponentLinkServlet.class);
    protected EndpointRegistry epRegistry;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String pcLink = req.getParameter("pcLink");
        if (pcLink == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_PCLINK", (Object[])new Object[0]));
        }
        Endpoint endpoint = this.epRegistry.resolve((EndpointResolver)new PortComponentResolver(pcLink));
        if (endpoint == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_RESOLVE_PORT_COMPONENT_LINK", (Object[])new Object[]{pcLink}));
        }
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
        String endpointAddress = sepMetaData.getEndpointAddress();
        out.println(endpointAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved " + pcLink + " to: " + endpointAddress));
        }
        out.close();
    }
}

