/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.lang.reflect.Method;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.AbstractSerializerFactory;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.NullValueSerializer;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.XMLContent;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;

public class ObjectContent
extends SOAPContent {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ObjectContent.class);
    private static Logger log = Logger.getLogger(ObjectContent.class);
    private Object objectValue;

    protected ObjectContent(SOAPContentElement container) {
        super(container);
    }

    @Override
    SOAPContent.State getState() {
        return SOAPContent.State.OBJECT_VALID;
    }

    @Override
    SOAPContent transitionTo(SOAPContent.State nextState) {
        SOAPContent next = null;
        if (nextState == SOAPContent.State.XML_VALID) {
            XMLFragment fragment = this.marshallObjectContents();
            XMLContent xmlValid = new XMLContent(this.container);
            xmlValid.setXMLFragment(fragment);
            next = xmlValid;
        } else if (nextState == SOAPContent.State.OBJECT_VALID) {
            next = this;
        } else if (nextState == SOAPContent.State.DOM_VALID) {
            XMLFragment fragment = this.marshallObjectContents();
            XMLContent tmp = new XMLContent(this.container);
            tmp.setXMLFragment(fragment);
            next = tmp.transitionTo(SOAPContent.State.DOM_VALID);
        } else {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ILLEGAL_STATE_REQUESTED", (Object[])new Object[]{nextState}));
        }
        return next;
    }

    @Override
    public Source getPayload() {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PAYLOAD_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    public void setPayload(Source source) {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PAYLOAD_CANNOT_BE_SET_ON_OBJECT_CONTENT", (Object[])new Object[0]));
    }

    @Override
    public XMLFragment getXMLFragment() {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLFRAGMENT_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    @Override
    public void setXMLFragment(XMLFragment xmlFragment) {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLFRAGMENT_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    @Override
    public Object getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(Object objValue) {
        this.objectValue = objValue;
    }

    private XMLFragment marshallObjectContents() {
        CommonMessageContext msgContext;
        QName xmlType = this.container.getXmlType();
        Class javaType = this.container.getJavaType();
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug((Object)("getXMLFragment from Object [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
        }
        if ((msgContext = MessageContextAssociation.peekMessageContext()) == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MESSAGECONTEXT_NOT_AVAILABLE", (Object[])new Object[0]));
        }
        SerializationContext serContext = msgContext.getSerializationContext();
        serContext.setJavaType(javaType);
        ParameterMetaData pmd = this.container.getParamMetaData();
        OperationMetaData opMetaData = pmd.getOperationMetaData();
        List<Class> registeredTypes = opMetaData.getEndpointMetaData().getRegisteredTypes();
        serContext.setProperty("org.jboss.ws.jaxb.context.types", registeredTypes.toArray(new Class[0]));
        TypeMappingImpl typeMapping = serContext.getTypeMapping();
        XMLFragment xmlFragment = null;
        try {
            SerializerSupport ser;
            if (this.objectValue != null) {
                AbstractSerializerFactory serializerFactory = this.getSerializerFactory(typeMapping, javaType, xmlType);
                ser = serializerFactory.getSerializer();
            } else {
                ser = new NullValueSerializer();
            }
            Result result = ser.serialize(this.container, serContext);
            xmlFragment = new XMLFragment(result);
            if (debugEnabled) {
                log.debug((Object)("xmlFragment: " + xmlFragment));
            }
        }
        catch (BindingException e) {
            throw new WSException(e);
        }
        return xmlFragment;
    }

    private AbstractSerializerFactory getSerializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType) {
        Class arrayWrapperType;
        AbstractSerializerFactory serializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(javaType, xmlType);
        if (serializerFactory == null && javaType.isArray() && (arrayWrapperType = typeMapping.getJavaType(xmlType)) != null) {
            try {
                Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
                Class<?> returnType = toArrayMethod.getReturnType();
                if (JavaUtils.isAssignableFrom((Class)javaType, returnType)) {
                    serializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(arrayWrapperType, xmlType);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (serializerFactory == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_SERIALIZER_FACTORY", (Object[])new Object[]{xmlType, javaType}));
        }
        return serializerFactory;
    }
}

