/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.rpc.Stub;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AttributedURI;
import org.jboss.ws.common.utils.UUIDGenerator;

public class AddressingClientUtil {
    private static AddressingBuilder BUILDER = AddressingBuilder.getAddressingBuilder();
    private static AddressingConstants CONSTANTS = BUILDER.newAddressingConstants();

    public static AddressingProperties createRequestProperties() {
        AddressingProperties addrProps = BUILDER.newAddressingProperties();
        addrProps.setMessageID(BUILDER.newURI(AddressingClientUtil.generateMessageID()));
        return addrProps;
    }

    public static AddressingProperties createDefaultProps(String wsaAction, String wsaTo) {
        try {
            AddressingProperties addrProps = AddressingClientUtil.createRequestProperties();
            addrProps.setMessageID(BUILDER.newURI(AddressingClientUtil.generateMessageID()));
            addrProps.setAction(BUILDER.newURI(wsaAction));
            addrProps.setTo(BUILDER.newURI(wsaTo));
            return addrProps;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static AddressingProperties createAnonymousProps(String wsaAction, String wsaTo) {
        try {
            AddressingProperties addrProps = AddressingClientUtil.createDefaultProps(wsaAction, wsaTo);
            addrProps.setReplyTo(BUILDER.newEndpointReference(new URI(CONSTANTS.getAnonymousURI())));
            return addrProps;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static AddressingProperties createOneWayProps(String wsaAction, String wsaTo) {
        try {
            AddressingProperties addrProps = AddressingClientUtil.createDefaultProps(wsaAction, wsaTo);
            addrProps.setReplyTo(BUILDER.newEndpointReference(new URI(CONSTANTS.getNoneURI())));
            return addrProps;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static void setTargetAddress(Stub stub, String url) {
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
    }

    public static URI generateMessageID() {
        URI messageId = null;
        try {
            messageId = new URI("urn:uuid:" + UUIDGenerator.generateRandomUUIDString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return messageId;
    }

    public static AttributedURI createMessageID() {
        return BUILDER.newURI(AddressingClientUtil.generateMessageID());
    }
}

