/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.jettison.badgerfish.BadgerFishXMLInputFactory;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BadgerFishDOMDocumentParser {
    private static final ResourceBundle bundle = BundleUtils.getBundle(BadgerFishDOMDocumentParser.class);

    public Document parse(InputStream input) throws IOException {
        try {
            BadgerFishXMLInputFactory inputFactory = new BadgerFishXMLInputFactory();
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(input);
            XMLInputFactory readerFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = readerFactory.createXMLEventReader(streamReader);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(baos);
            eventWriter.add(eventReader);
            eventWriter.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return DOMUtils.getDocumentBuilder().parse(bais);
        }
        catch (XMLStreamException ex) {
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE_INPUT_STREAM", (Object[])new Object[0]));
            ioex.initCause(ex);
            throw ioex;
        }
        catch (SAXException ex) {
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_IMPORT", (Object[])new Object[0]));
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

