/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.InvalidSecurityHeaderException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509IssuerSerial
extends Reference {
    private static final ResourceBundle bundle = BundleUtils.getBundle(X509IssuerSerial.class);
    private Document doc;
    private String issuer;
    private String serial;
    private Element cachedElement;

    public X509IssuerSerial(Document doc, BinarySecurityToken token) throws WSSecurityException {
        this.doc = doc;
        this.referenceToken(token);
    }

    public X509IssuerSerial(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        if (!"X509Data".equals(element.getLocalName())) {
            throw new InvalidSecurityHeaderException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_LOCAL_NAME_ON_X509", (Object[])new Object[0]));
        }
        if ((element = Util.getFirstChildElement(element)) == null) {
            throw new InvalidSecurityHeaderException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"X509DATAELEMENT_EMPTY", (Object[])new Object[0]));
        }
        if (!element.getLocalName().equals("X509IssuerSerial")) {
            throw new InvalidSecurityHeaderException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONLY_X509ISSUERSERIAL_SUPPORTED", (Object[])new Object[0]));
        }
        if ((element = Util.getFirstChildElement(element)) == null) {
            throw new InvalidSecurityHeaderException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"X509ISSUERSERIAL_EMPTY", (Object[])new Object[0]));
        }
        while (element != null) {
            String name = element.getLocalName();
            if (name.equals("X509IssuerName")) {
                this.issuer = XMLUtils.getFullTextChildrenFromElement((Element)element);
            } else if (name.equals("X509SerialNumber")) {
                this.serial = XMLUtils.getFullTextChildrenFromElement((Element)element);
            }
            element = Util.getNextSiblingElement(element);
        }
        if (this.serial == null) {
            throw new InvalidSecurityHeaderException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"X509SERIALNUMBER_MISSING", (Object[])new Object[0]));
        }
        if (this.issuer == null) {
            throw new InvalidSecurityHeaderException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"X509ISSUERNAME_MISSING", (Object[])new Object[0]));
        }
    }

    public void referenceToken(BinarySecurityToken token) throws WSSecurityException {
        if (!(token instanceof X509Token)) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"X509ISSUERSERIAL_TRIED_TO_REFERENCE", (Object[])new Object[0]));
        }
        X509Token x509 = (X509Token)token;
        X509Certificate cert = x509.getCert();
        this.issuer = ((Object)cert.getIssuerDN()).toString();
        this.serial = cert.getSerialNumber().toString();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSerial() {
        return this.serial;
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
        Element issuerSerial = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerSerial");
        element.appendChild(issuerSerial);
        Element issuerName = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerName");
        issuerName.appendChild(this.doc.createTextNode(this.issuer));
        issuerSerial.appendChild(issuerName);
        Element serialNumber = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SerialNumber");
        serialNumber.appendChild(this.doc.createTextNode(this.serial));
        issuerSerial.appendChild(serialNumber);
        this.cachedElement = element;
        return this.cachedElement;
    }
}

