/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.SecurityActions;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;

public class JAXWSMetaDataBuilderEJB3 {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSMetaDataBuilderEJB3.class);
    private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderEJB3.class);
    protected Class<?> annotatedClass;

    public UnifiedMetaData buildMetaData(ArchiveDeployment dep) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("START buildMetaData: [name=" + dep.getCanonicalName() + "]"));
        }
        try {
            UnifiedMetaData wsMetaData = (UnifiedMetaData)dep.getAttachment(UnifiedMetaData.class);
            if (wsMetaData == null) {
                wsMetaData = new UnifiedMetaData(dep.getRootFile());
                wsMetaData.setDeploymentName(dep.getCanonicalName());
                ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
                if (null == runtimeClassLoader) {
                    throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"RUNTIME_LOADER_CANNOT_BE_NULL", (Object[])new Object[0]));
                }
                wsMetaData.setClassLoader((ClassLoader)new DelegateClassLoader(runtimeClassLoader, SecurityActions.getContextClassLoader()));
            }
            EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
            Iterator it = apMetaData.getEnterpriseBeans();
            while (it.hasNext()) {
                String ejbLink;
                EJBMetaData beanMetaData = (EJBMetaData)it.next();
                String ejbClassName = beanMetaData.getEjbClass();
                Class<?> beanClass = wsMetaData.getClassLoader().loadClass(ejbClassName);
                Service service = dep.getService();
                if (service.getEndpointByName(ejbLink = beanMetaData.getEjbName()) == null || !beanClass.isAnnotationPresent(WebService.class) && !beanClass.isAnnotationPresent(WebServiceProvider.class)) continue;
                JAXWSServerMetaDataBuilder.setupProviderOrWebService(dep, wsMetaData, beanClass, ejbLink);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_BUILD_META_DATA", (Object[])new Object[]{ex.getMessage()}), ex);
        }
    }
}

