/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.xml.rpc.holders.Holder;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.metadata.wsdl.WSDLUtils;

public class HolderWriter {
    private static final ResourceBundle bundle = BundleUtils.getBundle(HolderWriter.class);
    private static final WSDLUtils utils = WSDLUtils.getInstance();
    private static final String newline = "\n";
    private HashMap<String, String> createdHolders = new HashMap();

    String getOrCreateHolder(String type, File pkgLoc) {
        String fullHolderName = this.createdHolders.get(type);
        if (fullHolderName == null) {
            StringBuilder buf = new StringBuilder();
            fullHolderName = this.writeHolder(type, buf);
            this.createdHolders.put(type, fullHolderName);
            String holderName = fullHolderName.substring(fullHolderName.lastIndexOf(46) + 1);
            try {
                File sei = utils.createPhysicalFile(pkgLoc, holderName);
                FileWriter writer = new FileWriter(sei);
                writer.write(buf.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_CREATE_JAX_RPC_HOLDER", (Object[])new Object[0]), e);
            }
        }
        return fullHolderName;
    }

    private String writeHolder(String type, StringBuilder buf) {
        String pkg = type.substring(0, type.lastIndexOf(46));
        String typeName = type.substring(type.lastIndexOf(46) + 1);
        String holderName = typeName + "Holder";
        utils.writeJbossHeader(buf);
        buf.append(newline);
        buf.append("package ").append(pkg).append(";").append(newline);
        buf.append(newline);
        buf.append("public class ").append(holderName).append(" implements ").append(Holder.class.getName());
        buf.append(newline).append("{").append(newline);
        buf.append(newline);
        buf.append("  public ").append(type).append(" value;");
        buf.append(newline);
        buf.append(newline);
        buf.append("  ").append("public ").append(holderName).append("()").append(newline);
        buf.append("  {").append(newline);
        buf.append("    this.value = new ").append(type).append("();").append(newline);
        buf.append("  }").append(newline);
        buf.append(newline);
        buf.append("  ").append("public ").append(holderName).append("(final ").append(type).append(" value)").append(newline);
        buf.append("  {").append(newline);
        buf.append("    this.value = value;").append(newline);
        buf.append("  }").append(newline);
        buf.append(newline);
        buf.append("}").append(newline);
        return pkg + "." + holderName;
    }
}

