/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.naming.Name;
import org.jacorb.naming.namemanager.ContextNode;
import org.jacorb.naming.namemanager.NSTable;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NSTree
extends JTree {
    public static final int MAX_BIND = 40;
    private NamingContextExt rootContext;
    private ContextNode rootNode;
    private Dimension size;
    private boolean created;
    private ORB orb;
    public static NSTable nsTable;

    public NSTree(int n, int n2, NSTable nSTable, NamingContextExt namingContextExt, ORB oRB) {
        this.orb = oRB;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("RootContext");
        defaultMutableTreeNode.setAllowsChildren(true);
        this.setModel(new DefaultTreeModel(defaultMutableTreeNode, true));
        this.created = false;
        this.size = new Dimension(n, n2);
        nsTable = nSTable;
        this.rootContext = namingContextExt;
        ContextNode contextNode = new ContextNode(this.rootContext, (DefaultTreeModel)this.getModel());
        contextNode.setNode(defaultMutableTreeNode);
        defaultMutableTreeNode.setUserObject(contextNode);
    }

    public void bind(String string) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        TreePath treePath = null;
        int n = 0;
        try {
            treePath = this.getSelectionPath();
            n = treePath.getPathCount();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Nothing selected", "Selection error", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        NamingContextExt namingContextExt = this.rootContext;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(i);
                ContextNode contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                if ((namingContextExt = NamingContextExtHelper.narrow(namingContextExt.resolve(contextNode.getName()))) != null) continue;
                System.err.println("Naming context narrow failed!");
                System.exit(1);
            }
        }
        if (defaultMutableTreeNode.getAllowsChildren()) {
            Name name = new Name(string);
            if (namingContextExt == null) {
                System.err.println("context null ");
            }
            if (name.components() == null) {
                System.err.println("name is null ");
            }
            namingContextExt.bind_new_context(name.components());
            this.update();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a naming context", "Selection error", 0);
        }
    }

    public void bindObject(String string, String string2, boolean bl) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        TreePath treePath = null;
        int n = 0;
        try {
            treePath = this.getSelectionPath();
            n = treePath.getPathCount();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Nothing selected", "Selection error", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        NamingContextExt namingContextExt = this.rootContext;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(i);
                ContextNode contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                if ((namingContextExt = NamingContextExtHelper.narrow(namingContextExt.resolve(contextNode.getName()))) != null) continue;
                System.err.println("Naming context narrow failed!");
                System.exit(1);
            }
        }
        if (defaultMutableTreeNode.getAllowsChildren()) {
            Name name = new Name(string);
            if (namingContextExt == null) {
                System.err.println("context null ");
            }
            if (name.components() == null) {
                System.err.println("name is null ");
            }
            try {
                namingContextExt.bind(name.components(), this.orb.string_to_object(string2));
            }
            catch (AlreadyBound alreadyBound) {
                if (bl) {
                    namingContextExt.rebind(name.components(), this.orb.string_to_object(string2));
                }
                throw alreadyBound;
            }
            this.update();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a naming context", "Selection error", 0);
        }
    }

    public Dimension getPreferredSize() {
        if (!this.created) {
            this.created = true;
            return this.size;
        }
        return super.getPreferredSize();
    }

    public void unbind() {
        NamingContextExt namingContextExt = this.rootContext;
        TreePath treePath = null;
        int n = 0;
        try {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            treePath = this.getSelectionPath();
            n = treePath.getPathCount();
            if (n > 1) {
                for (int i = 1; i < n - 1; ++i) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(i);
                    object = (ContextNode)defaultMutableTreeNode.getUserObject();
                    namingContextExt = NamingContextExtHelper.narrow(namingContextExt.resolve(((ContextNode)object).getName()));
                }
            }
            if (n > 0) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n - 1);
                ContextNode contextNode = (ContextNode)defaultMutableTreeNode.getUserObject();
                namingContextExt.unbind(contextNode.getName());
                object = (DefaultTreeModel)this.getModel();
                ((DefaultTreeModel)object).removeNodeFromParent(defaultMutableTreeNode);
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(n - 2);
                this.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                ((ContextNode)defaultMutableTreeNode2.getUserObject()).display();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Nothing selected or invalid selection", "Selection error", 0);
        }
    }

    public synchronized void update() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        ((ContextNode)((DefaultMutableTreeNode)defaultTreeModel.getRoot()).getUserObject()).update();
        nsTable.update();
    }
}

