/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class CollectionsWrapper {
    private static Method singletonListMethod;

    public static List singletonList(Object object) {
        if (singletonListMethod != null) {
            try {
                return (List)singletonListMethod.invoke(null, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new SingletonList(object);
    }

    static {
        try {
            singletonListMethod = Collections.class.getMethod("singletonList", Object.class);
        }
        catch (Exception exception) {
            singletonListMethod = null;
        }
    }

    private static class SingletonList
    extends AbstractList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object singletonElement_;

        SingletonList(Object object) {
            this.singletonElement_ = object;
        }

        public int size() {
            return 1;
        }

        public boolean contains(Object object) {
            if (this.singletonElement_ == null) {
                return object == null;
            }
            return object.equals(this.singletonElement_);
        }

        public Object get(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Index: " + n);
            }
            return this.singletonElement_;
        }
    }
}

