/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.impl.ClusteringImplMessages;
import org.jgroups.Address;

public class ClusterNodeImpl
implements ClusterNode {
    private static final long serialVersionUID = -1831036833785680731L;
    private final String id;
    private transient Address jgAddress;
    private final InetSocketAddress socketAddress;

    ClusterNodeImpl(String id, Address jgAddress, InetSocketAddress socketAddress) {
        if (id == null) {
            throw ClusteringImplMessages.MESSAGES.nullVar("id");
        }
        if (socketAddress == null) {
            throw ClusteringImplMessages.MESSAGES.nullVar("addressPort");
        }
        this.id = id;
        this.socketAddress = socketAddress;
        this.jgAddress = jgAddress;
    }

    public String getName() {
        return this.id;
    }

    public InetAddress getIpAddress() {
        return this.socketAddress.getAddress();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    Address getOriginalJGAddress() {
        return this.jgAddress;
    }

    public int compareTo(ClusterNode o) {
        return this.id.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNodeImpl)) {
            return false;
        }
        ClusterNodeImpl other = (ClusterNodeImpl)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.jgAddress.getClass().getName());
        try {
            this.jgAddress.writeTo((DataOutput)out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.jgAddress = Address.class.getClassLoader().loadClass(in.readUTF()).asSubclass(Address.class).newInstance();
            this.jgAddress.readFrom((DataInput)in);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

