/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.configadmin.parser.Namespace;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ConfigAdminProviders {
    static final String RESOURCE_NAME = ConfigAdminProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode subsystem = new ModelNode();
            ResourceBundle resbundle = ConfigAdminProviders.getResourceBundle(locale);
            subsystem.get("description").set(resbundle.getString("subsystem"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get(new String[]{"children", "configuration", "description"}).set(resbundle.getString("configuration"));
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = ConfigAdminProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle2.getString("subsystem.remove"));
            op.get("reply-properties").setEmptyObject();
            op.get("request-properties").setEmptyObject();
            return op;
        }
    };
    static final DescriptionProvider CONFIGURATION_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = ConfigAdminProviders.getResourceBundle(locale);
            node.get("description").set(resbundle.getString("configuration"));
            node.get(new String[]{"attributes", "entries", "description"}).set(resbundle.getString("configuration.entries"));
            node.get(new String[]{"attributes", "entries", "required"}).set(true);
            node.get(new String[]{"attributes", "entries", "type"}).set(ModelType.LIST);
            node.get(new String[]{"attributes", "entries", "value-type"}).set(ModelType.PROPERTY);
            node.get(new String[]{"attributes", "entries", "access-type"}).set(AttributeAccess.AccessType.READ_WRITE.toString());
            node.get(new String[]{"attributes", "entries", "restart-required"}).set(AttributeAccess.Flag.RESTART_NONE.toString());
            return node;
        }
    };

    ConfigAdminProviders() {
    }

    static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale != null ? locale : Locale.getDefault());
    }
}

