/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.HashSet;
import java.util.List;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleValidator;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.osgi.framework.BundleException;

final class BundleValidatorR4
implements BundleValidator {
    BundleValidatorR4() {
    }

    @Override
    public void validateBundle(UserBundleState userBundle, OSGiMetaData osgiMetaData) throws BundleException {
        List dynamicImports;
        List exportPackages;
        String packageName;
        String symbolicName = osgiMetaData.getBundleSymbolicName();
        if (symbolicName == null) {
            throw new BundleException("Missing Bundle-SymbolicName in: " + userBundle);
        }
        int manifestVersion = osgiMetaData.getBundleManifestVersion();
        if (manifestVersion > 2) {
            throw new BundleException("Unsupported manifest version " + manifestVersion + " for " + userBundle);
        }
        List importPackages = osgiMetaData.getImportPackages();
        if (importPackages != null) {
            HashSet<String> packages = new HashSet<String>();
            for (PackageAttribute packageAttribute : importPackages) {
                packageName = packageAttribute.getAttribute();
                if (packages.contains(packageName)) {
                    throw new BundleException("Duplicate import of package " + packageName + " for " + userBundle);
                }
                packages.add(packageName);
                if (packageName.startsWith("java.")) {
                    throw new BundleException("Not allowed to import java.* for " + userBundle);
                }
                String version = (String)packageAttribute.getAttributeValue("version", String.class);
                String specificationVersion = (String)packageAttribute.getAttributeValue("specification-version", String.class);
                if (version == null || specificationVersion == null || version.equals(specificationVersion)) continue;
                throw new BundleException(packageName + " version and specification version should be the same in: " + userBundle);
            }
        }
        if ((exportPackages = osgiMetaData.getExportPackages()) != null) {
            for (PackageAttribute packageAttr : exportPackages) {
                packageName = packageAttr.getAttribute();
                if (packageName.startsWith("java.")) {
                    throw new BundleException("Not allowed to export java.* for " + userBundle);
                }
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr != null && specificationAttr != null && !versionAttr.equals(specificationAttr)) {
                    throw new BundleException(packageName + " version and specification version should be the same in: " + userBundle);
                }
                String symbolicNameAttr = (String)packageAttr.getAttributeValue("bundle-symbolic-name", String.class);
                if (symbolicNameAttr != null) {
                    throw new BundleException(packageName + " must not specify an explicit bundle symbolic name in: " + userBundle);
                }
                String bundleVersionAttr = (String)packageAttr.getAttributeValue("bundle-version", String.class);
                if (bundleVersionAttr == null) continue;
                throw new BundleException(packageName + " must not specify an explicit bundle version in: " + userBundle);
            }
        }
        if ((dynamicImports = osgiMetaData.getDynamicImports()) != null) {
            for (PackageAttribute packageAttr : dynamicImports) {
                String packageName2 = packageAttr.getAttribute();
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr == null || specificationAttr == null || versionAttr.equals(specificationAttr)) continue;
                throw new BundleException(packageName2 + " version and specification version should be the same in: " + userBundle);
            }
        }
        for (AbstractBundleState aux : userBundle.getBundleManager().getBundles()) {
            if (!userBundle.getCanonicalName().equals(aux.getCanonicalName())) continue;
            throw new BundleException("Cannot install bundle, name and version already installed: " + aux);
        }
        if (userBundle.isFragment()) {
            ParameterizedAttribute hostAttr = osgiMetaData.getFragmentHost();
            String fragmentHost = hostAttr.getAttribute();
            String extension = (String)hostAttr.getDirectiveValue("extension", String.class);
            if (extension != null) {
                if (!"system.bundle".equals(fragmentHost)) {
                    throw new BundleException("Invalid Fragment-Host for extension fragment: " + userBundle);
                }
                if ("bootclasspath".equals(extension)) {
                    throw new UnsupportedOperationException("Boot classpath extension not supported");
                }
                if ("framework".equals(extension)) {
                    throw new UnsupportedOperationException("Framework extension not supported");
                }
            }
        }
    }
}

