/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.security;

import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.WSSPolicyException;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;

public class GCMAlgorithmSuite
extends AlgorithmSuite {
    public GCMAlgorithmSuite(SPConstants version) {
        super(version);
    }

    public GCMAlgorithmSuite() {
        super((SPConstants)SP12Constants.INSTANCE);
    }

    public void setAlgorithmSuite(String algoSuite) throws WSSPolicyException {
        this.algoSuiteString = algoSuite;
        if ("Basic128GCM".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2009/xmlenc11#aes128-gcm";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
        } else if ("Basic192GCM".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2009/xmlenc11#aes192-gcm";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256GCM".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
            this.encryptionDerivedKeyLength = 256;
        }
    }
}

