/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.HashMap;
import java.util.Map;

enum Attribute {
    UNKNOWN(null),
    LOAD_METRIC("load-metric"),
    PROXY_CONF("proxy-conf"),
    HTTPD_CONF("httpd-conf"),
    NODES_CONF("nodes-conf"),
    ADVERTISE_SOCKET("advertise-socket"),
    SSL("ssl"),
    PROXY_LIST("proxy-list"),
    PROXY_URL("proxy-url"),
    ADVERTISE("advertise"),
    ADVERTISE_SECURITY_KEY("advertise-security-key"),
    LOAD_PROVIDER("load-provider"),
    SIMPLE_LOAD_PROVIDER("simple-load-provider"),
    DYNAMIC_LOAD_PROVIDER("dynamic-load-provider"),
    CUSTOM_LOAD_METRIC("custom-load-metric"),
    EXCLUDED_CONTEXTS("excluded-contexts"),
    AUTO_ENABLE_CONTEXTS("auto-enable-contexts"),
    STOP_CONTEXT_TIMEOUT("stop-context-timeout"),
    SOCKET_TIMEOUT("socket-timeout"),
    STICKY_SESSION("sticky-session"),
    STICKY_SESSION_REMOVE("sticky-session-remove"),
    STICKY_SESSION_FORCE("sticky-session-force"),
    WORKER_TIMEOUT("worker-timeout"),
    MAX_ATTEMPTS("max-attempts"),
    FLUSH_PACKETS("flush-packets"),
    FLUSH_WAIT("flush-wait"),
    PING("ping"),
    SMAX("smax"),
    TTL("ttl"),
    NODE_TIMEOUT("node-timeout"),
    BALANCER("balancer"),
    DOMAIN("domain"),
    FACTOR("factor"),
    HISTORY("history"),
    DECAY("decay"),
    NAME("name"),
    CAPACITY("capacity"),
    WEIGHT("weight"),
    TYPE("type"),
    CLASS("class"),
    PROPERTY("property"),
    VALUE("value"),
    KEY_ALIAS("key-alias"),
    PASSWORD("password"),
    CERTIFICATE_KEY_FILE("certificate-key-file"),
    CIPHER_SUITE("cipher-suite"),
    PROTOCOL("protocol"),
    CA_CERTIFICATE_FILE("ca-certificate-file"),
    CA_REVOCATION_URL("ca-revocation-url");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

