/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ContextHost;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterStopContext
implements OperationStepHandler,
DescriptionProvider {
    static final ModClusterStopContext INSTANCE = new ModClusterStopContext();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getStopContextDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    ModCluster modcluster = (ModCluster)controller.getValue();
                    ModClusterLogger.ROOT_LOGGER.debugf("stop-context: %s", operation);
                    ContextHost contexthost = new ContextHost(operation);
                    modcluster.stopContext(contexthost.webhost, contexthost.webcontext, contexthost.waittime);
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

