/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.Vector;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDTDDescription
extends XMLResourceIdentifierImpl
implements org.apache.xerces.xni.grammars.XMLDTDDescription {
    protected String fRootName = null;
    protected Vector fPossibleRoots = null;

    public XMLDTDDescription(XMLResourceIdentifier id, String rootName) {
        this.setValues(id.getPublicId(), id.getLiteralSystemId(), id.getBaseSystemId(), id.getExpandedSystemId());
        this.fRootName = rootName;
        this.fPossibleRoots = null;
    }

    public XMLDTDDescription(String publicId, String literalId, String baseId, String expandedId, String rootName) {
        this.setValues(publicId, literalId, baseId, expandedId);
        this.fRootName = rootName;
        this.fPossibleRoots = null;
    }

    public XMLDTDDescription(XMLInputSource source) {
        this.setValues(source.getPublicId(), null, source.getBaseSystemId(), source.getSystemId());
        this.fRootName = null;
        this.fPossibleRoots = null;
    }

    @Override
    public String getGrammarType() {
        return "http://www.w3.org/TR/REC-xml";
    }

    @Override
    public String getRootName() {
        return this.fRootName;
    }

    public void setRootName(String rootName) {
        this.fRootName = rootName;
        this.fPossibleRoots = null;
    }

    public void setPossibleRoots(Vector possibleRoots) {
        this.fPossibleRoots = possibleRoots;
    }

    public boolean equals(Object desc) {
        if (!(desc instanceof XMLGrammarDescription)) {
            return false;
        }
        if (!this.getGrammarType().equals(((XMLGrammarDescription)desc).getGrammarType())) {
            return false;
        }
        XMLDTDDescription dtdDesc = (XMLDTDDescription)desc;
        if (this.fRootName != null) {
            if (dtdDesc.fRootName != null && !dtdDesc.fRootName.equals(this.fRootName)) {
                return false;
            }
            if (dtdDesc.fPossibleRoots != null && !dtdDesc.fPossibleRoots.contains(this.fRootName)) {
                return false;
            }
        } else if (this.fPossibleRoots != null) {
            if (dtdDesc.fRootName != null) {
                if (!this.fPossibleRoots.contains(dtdDesc.fRootName)) {
                    return false;
                }
            } else {
                String root;
                if (dtdDesc.fPossibleRoots == null) {
                    return false;
                }
                boolean found = false;
                for (int i = 0; i < this.fPossibleRoots.size() && !(found = dtdDesc.fPossibleRoots.contains(root = (String)this.fPossibleRoots.elementAt(i))); ++i) {
                }
                if (!found) {
                    return false;
                }
            }
        }
        if (this.fExpandedSystemId != null ? !this.fExpandedSystemId.equals(dtdDesc.fExpandedSystemId) : dtdDesc.fExpandedSystemId != null) {
            return false;
        }
        return !(this.fPublicId != null ? !this.fPublicId.equals(dtdDesc.fPublicId) : dtdDesc.fPublicId != null);
    }

    @Override
    public int hashCode() {
        if (this.fExpandedSystemId != null) {
            return this.fExpandedSystemId.hashCode();
        }
        if (this.fPublicId != null) {
            return this.fPublicId.hashCode();
        }
        return 0;
    }
}

