/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.ShortList;

public class ValidatedInfo {
    public String normalizedValue;
    public Object actualValue;
    public short actualValueType;
    public XSSimpleType memberType;
    public XSSimpleType[] memberTypes;
    public ShortList itemValueTypes;

    public void reset() {
        this.normalizedValue = null;
        this.actualValue = null;
        this.memberType = null;
        this.memberTypes = null;
    }

    public String stringValue() {
        if (this.actualValue == null) {
            return this.normalizedValue;
        }
        return this.actualValue.toString();
    }

    public static boolean isComparable(ValidatedInfo info1, ValidatedInfo info2) {
        short primitiveType2;
        short primitiveType1 = ValidatedInfo.convertToPrimitiveKind(info1.actualValueType);
        if (primitiveType1 != (primitiveType2 = ValidatedInfo.convertToPrimitiveKind(info2.actualValueType))) {
            return primitiveType1 == 1 && primitiveType2 == 2 || primitiveType1 == 2 && primitiveType2 == 1;
        }
        if (primitiveType1 == 44 || primitiveType1 == 43) {
            int typeList2Length;
            ShortList typeList1 = info1.itemValueTypes;
            ShortList typeList2 = info2.itemValueTypes;
            int typeList1Length = typeList1 != null ? typeList1.getLength() : 0;
            int n = typeList2Length = typeList2 != null ? typeList2.getLength() : 0;
            if (typeList1Length != typeList2Length) {
                return false;
            }
            for (int i = 0; i < typeList1Length; ++i) {
                short primitiveItem2;
                short primitiveItem1 = ValidatedInfo.convertToPrimitiveKind(typeList1.item(i));
                if (primitiveItem1 == (primitiveItem2 = ValidatedInfo.convertToPrimitiveKind(typeList2.item(i))) || primitiveItem1 == 1 && primitiveItem2 == 2 || primitiveItem1 == 2 && primitiveItem2 == 1) continue;
                return false;
            }
        }
        return true;
    }

    private static short convertToPrimitiveKind(short valueType) {
        if (valueType <= 20) {
            return valueType;
        }
        if (valueType <= 29) {
            return 2;
        }
        if (valueType <= 42) {
            return 4;
        }
        return valueType;
    }
}

