/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.integration;

import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.EndpointTypeFilterImpl;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentType;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.deployment.EndpointTypeFilter;

public final class WSHelper {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSHelper.class);
    private static final Logger LOG = Logger.getLogger(WSHelper.class);
    private static final EndpointTypeFilter JAXRPC_EJB_ENDPOINT_FILTER = new EndpointTypeFilterImpl(EndpointType.JAXRPC_EJB21);
    private static final EndpointTypeFilter JAXRPC_JSE_ENDPOINT_FILTER = new EndpointTypeFilterImpl(EndpointType.JAXRPC_JSE);
    private static final EndpointTypeFilter JAXWS_EJB_ENDPOINT_FILTER = new EndpointTypeFilterImpl(EndpointType.JAXWS_EJB3);
    private static final EndpointTypeFilter JAXWS_JSE_ENDPOINT_FILTER = new EndpointTypeFilterImpl(EndpointType.JAXWS_JSE);
    private static final String WAR_EXTENSION = ".war";
    private static final String JAR_EXTENSION = ".jar";
    private static final String EAR_EXTENSION = ".ear";

    private WSHelper() {
    }

    public static <A> A getRequiredAttachment(Deployment dep, Class<A> key) {
        Object value = dep.getAttachment(key);
        if (value == null) {
            LOG.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CAN_NOT_FIND_ATTACHMENT", (Object[])new Object[]{key}));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(Deployment dep, Class<A> key) {
        return (A)dep.getAttachment(key);
    }

    public static boolean hasAttachment(Deployment dep, Class<?> key) {
        return WSHelper.getOptionalAttachment(dep, key) != null;
    }

    public static boolean isJaxwsJseDeployment(Deployment dep) {
        return WSHelper.isJaxwsDeployment(dep) && dep.getService().getEndpoints(JAXWS_JSE_ENDPOINT_FILTER).size() > 0;
    }

    public static boolean isJaxwsEjbDeployment(Deployment dep) {
        return WSHelper.isJaxwsDeployment(dep) && dep.getService().getEndpoints(JAXWS_EJB_ENDPOINT_FILTER).size() > 0;
    }

    public static boolean isJaxrpcJseDeployment(Deployment dep) {
        return WSHelper.isJaxrpcDeployment(dep) && dep.getService().getEndpoints(JAXRPC_JSE_ENDPOINT_FILTER).size() > 0;
    }

    public static boolean isJaxrpcEjbDeployment(Deployment dep) {
        return WSHelper.isJaxrpcDeployment(dep) && dep.getService().getEndpoints(JAXRPC_EJB_ENDPOINT_FILTER).size() > 0;
    }

    public static boolean isJseDeployment(Deployment dep) {
        return WSHelper.isJaxwsJseDeployment(dep) || WSHelper.isJaxrpcJseDeployment(dep);
    }

    public static boolean isEjbDeployment(Deployment dep) {
        return WSHelper.isJaxwsEjbDeployment(dep) || WSHelper.isJaxrpcEjbDeployment(dep);
    }

    public static boolean isJaxwsDeployment(Deployment dep) {
        return DeploymentType.JAXWS == dep.getType();
    }

    public static boolean isJaxrpcDeployment(Deployment dep) {
        return DeploymentType.JAXRPC == dep.getType();
    }

    public static boolean isJarArchive(Deployment dep) {
        return dep.getSimpleName().endsWith(JAR_EXTENSION);
    }

    public static boolean isWarArchive(Deployment dep) {
        return dep.getSimpleName().endsWith(WAR_EXTENSION);
    }

    public static boolean isEarArchive(Deployment dep) {
        return dep.getSimpleName().endsWith(EAR_EXTENSION);
    }

    public static boolean isJaxwsJseEndpoint(Endpoint ep) {
        return EndpointType.JAXWS_JSE == ep.getType();
    }

    public static boolean isJaxwsEjbEndpoint(Endpoint ep) {
        return EndpointType.JAXWS_EJB3 == ep.getType();
    }

    public static boolean isJaxrpcJseEndpoint(Endpoint ep) {
        return EndpointType.JAXRPC_JSE == ep.getType();
    }

    public static boolean isJaxrpcEjbEndpoint(Endpoint ep) {
        return EndpointType.JAXRPC_EJB21 == ep.getType();
    }

    public static boolean isJseEndpoint(Endpoint ep) {
        return WSHelper.isJaxwsJseEndpoint(ep) || WSHelper.isJaxrpcJseEndpoint(ep);
    }

    public static boolean isEjbEndpoint(Endpoint ep) {
        return WSHelper.isJaxwsEjbEndpoint(ep) || WSHelper.isJaxrpcEjbEndpoint(ep);
    }

    public static boolean isJaxwsEndpoint(Endpoint ep) {
        return WSHelper.isJaxwsJseEndpoint(ep) || WSHelper.isJaxwsEjbEndpoint(ep);
    }

    public static boolean isJaxrpcEndpoint(Endpoint ep) {
        return WSHelper.isJaxrpcJseEndpoint(ep) || WSHelper.isJaxrpcEjbEndpoint(ep);
    }
}

