/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.invocation;

import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.api.handler.GenericSOAPHandler;
import org.jboss.ws.api.monitoring.Record;
import org.jboss.ws.api.monitoring.RecordGroupAssociation;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.monitoring.RecordFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.w3c.dom.Node;

public class RecordingServerHandler
extends GenericSOAPHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(RecordingServerHandler.class);
    private static Logger log = Logger.getLogger(RecordingServerHandler.class);

    protected boolean handleInbound(MessageContext ctx) {
        Endpoint endpoint = EndpointAssociation.getEndpoint();
        if (endpoint != null && this.isRecording(endpoint)) {
            Record record = RecordFactory.newRecord();
            RecordGroupAssociation.pushGroupID((String)record.getGroupID());
            record.setDate(new Date());
            HttpServletRequest httpServletRequest = (HttpServletRequest)ctx.get((Object)"javax.xml.ws.servlet.request");
            if (httpServletRequest != null) {
                try {
                    record.setDestinationHost(new URL(httpServletRequest.getRequestURL().toString()).getHost());
                    record.setSourceHost(httpServletRequest.getRemoteHost());
                }
                catch (Exception e) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_READ_FROM_THE_HTTP_SERVLET_REQUEST", (Object[])new Object[]{e.getMessage()}));
                }
            }
            record.setHeaders((Map)ctx.get((Object)"javax.xml.ws.http.request.headers"));
            record.setMessageType(Record.MessageType.INBOUND);
            record.setOperation((QName)ctx.get((Object)"javax.xml.ws.wsdl.operation"));
            boolean processEnvelope = false;
            Iterator it = endpoint.getRecordProcessors().iterator();
            while (it.hasNext() && !processEnvelope) {
                processEnvelope = ((RecordProcessor)it.next()).isProcessEnvelope();
            }
            if (processEnvelope) {
                SOAPMessageContext soapCtx = (SOAPMessageContext)ctx;
                try {
                    SOAPEnvelope soapEnv = soapCtx.getMessage().getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        record.setEnvelope(DOMWriter.printNode((Node)soapEnv, true));
                    }
                }
                catch (SOAPException ex) {
                    log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_TRACE_SOAPMESSAGE", (Object[])new Object[0]), (Throwable)ex);
                }
            }
            endpoint.processRecord(record);
        }
        return true;
    }

    protected boolean handleOutbound(MessageContext ctx) {
        Endpoint endpoint = EndpointAssociation.getEndpoint();
        if (endpoint != null && this.isRecording(endpoint)) {
            String groupID = RecordGroupAssociation.popGroupID();
            Record record = RecordFactory.newRecord(groupID);
            record.setDate(new Date());
            record.setHeaders((Map)ctx.get((Object)"javax.xml.ws.http.response.headers"));
            record.setMessageType(Record.MessageType.OUTBOUND);
            record.setOperation((QName)ctx.get((Object)"javax.xml.ws.wsdl.operation"));
            boolean processEnvelope = false;
            Iterator it = endpoint.getRecordProcessors().iterator();
            while (it.hasNext() && !processEnvelope) {
                processEnvelope = ((RecordProcessor)it.next()).isProcessEnvelope();
            }
            if (processEnvelope) {
                SOAPMessageContext soapCtx = (SOAPMessageContext)ctx;
                try {
                    SOAPEnvelope soapEnv = soapCtx.getMessage().getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        record.setEnvelope(DOMWriter.printNode((Node)soapEnv, true));
                    }
                }
                catch (SOAPException ex) {
                    log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_TRACE_SOAPMESSAGE", (Object[])new Object[0]), (Throwable)ex);
                }
            }
            endpoint.processRecord(record);
        }
        return true;
    }

    public boolean handleFault(MessageContext ctx) {
        return this.handleOutbound(ctx);
    }

    private boolean isRecording(Endpoint endpoint) {
        List processors = endpoint.getRecordProcessors();
        if (processors == null || processors.isEmpty()) {
            return false;
        }
        for (RecordProcessor processor : processors) {
            if (!processor.isRecording()) continue;
            return true;
        }
        return false;
    }
}

