/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerEnvironment;

public class LocalHostControllerInfoImpl
implements LocalHostControllerInfo {
    private final ControlledProcessState processState;
    private final HostControllerEnvironment hostEnvironment;
    private final String localHostName;
    private boolean master;
    private String nativeManagementInterface;
    private int nativeManagementPort;
    private String remoteDcHost;
    private int remoteDcPort;
    private String remoteSecurityRealm;
    private String httpManagementInterface;
    private int httpManagementPort;
    private int httpManagementSecurePort;
    private String nativeManagementSecurityRealm;
    private String httpManagementSecurityRealm;

    public LocalHostControllerInfoImpl(ControlledProcessState processState, String localHostName) {
        this.processState = processState;
        this.hostEnvironment = null;
        this.localHostName = localHostName;
    }

    public LocalHostControllerInfoImpl(ControlledProcessState processState, HostControllerEnvironment hostEnvironment) {
        this.processState = processState;
        this.hostEnvironment = hostEnvironment;
        this.localHostName = null;
    }

    @Override
    public String getLocalHostName() {
        return this.hostEnvironment == null ? this.localHostName : this.hostEnvironment.getHostControllerName();
    }

    @Override
    public ControlledProcessState.State getProcessState() {
        return this.processState.getState();
    }

    @Override
    public boolean isMasterDomainController() {
        return this.master;
    }

    @Override
    public String getNativeManagementInterface() {
        return this.nativeManagementInterface;
    }

    @Override
    public int getNativeManagementPort() {
        return this.nativeManagementPort;
    }

    @Override
    public String getNativeManagementSecurityRealm() {
        return this.nativeManagementSecurityRealm;
    }

    @Override
    public String getHttpManagementInterface() {
        return this.httpManagementInterface;
    }

    @Override
    public int getHttpManagementPort() {
        return this.httpManagementPort;
    }

    @Override
    public int getHttpManagementSecurePort() {
        return this.httpManagementSecurePort;
    }

    @Override
    public String getHttpManagementSecurityRealm() {
        return this.httpManagementSecurityRealm;
    }

    @Override
    public String getRemoteDomainControllerHost() {
        return this.remoteDcHost;
    }

    @Override
    public int getRemoteDomainControllerPort() {
        return this.remoteDcPort;
    }

    public String getRemoteDomainControllerSecurityRealm() {
        return this.remoteSecurityRealm;
    }

    void setMasterDomainController(boolean master) {
        this.master = master;
    }

    void setNativeManagementInterface(String nativeManagementInterface) {
        this.nativeManagementInterface = nativeManagementInterface;
    }

    void setNativeManagementPort(int nativeManagementPort) {
        this.nativeManagementPort = nativeManagementPort;
    }

    void setNativeManagementSecurityRealm(String nativeManagementSecurityRealm) {
        this.nativeManagementSecurityRealm = nativeManagementSecurityRealm;
    }

    void setHttpManagementInterface(String httpManagementInterface) {
        this.httpManagementInterface = httpManagementInterface;
    }

    void setHttpManagementPort(int httpManagementPort) {
        this.httpManagementPort = httpManagementPort;
    }

    void setHttpManagementSecurePort(int httpManagementSecurePort) {
        this.httpManagementSecurePort = httpManagementSecurePort;
    }

    void setHttpManagementSecurityRealm(String httpManagementSecurityRealm) {
        this.httpManagementSecurityRealm = httpManagementSecurityRealm;
    }

    void setRemoteDomainControllerHost(String host) {
        this.remoteDcHost = host;
    }

    void setRemoteDomainControllerPort(int port) {
        this.remoteDcPort = port;
    }

    public void setRemoteDomainControllerSecurityRealm(String remoteSecurityRealm) {
        this.remoteSecurityRealm = remoteSecurityRealm;
    }
}

