/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.UUID;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupImpl;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupSerializabilityChecker;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryFactory;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.ReplicationPassivationManager;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SerializabilityChecker;

public class SerializationGroupContainer<K extends Serializable, V extends Cacheable<K>>
implements BackingCacheEntryFactory<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>>,
ReplicationPassivationManager<UUID, SerializationGroup<K, V, UUID>>,
StatefulObjectFactory<Cacheable<UUID>> {
    private static final Logger log = Logger.getLogger(SerializationGroupContainer.class);
    private PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache;
    private final MarshallingConfiguration marshallingConfiguration;
    private final SerializationGroupSerializabilityChecker serializabilityChecker = new SerializationGroupSerializabilityChecker();
    private boolean clustered;

    public SerializationGroupContainer(PassivationManager<K, V> passivationManager) {
        this.serializabilityChecker.addSerializabilityChecker(SerializabilityChecker.DEFAULT);
        MarshallingConfiguration config = passivationManager.getMarshallingConfiguration();
        this.marshallingConfiguration = new MarshallingConfiguration();
        this.marshallingConfiguration.setBufferSize(config.getBufferSize());
        this.marshallingConfiguration.setClassCount(config.getClassCount());
        this.marshallingConfiguration.setClassExternalizerFactory(config.getClassExternalizerFactory());
        this.marshallingConfiguration.setClassResolver(config.getClassResolver());
        this.marshallingConfiguration.setClassTable(config.getClassTable());
        this.marshallingConfiguration.setExceptionListener(config.getExceptionListener());
        this.marshallingConfiguration.setExternalizerCreator(config.getExternalizerCreator());
        this.marshallingConfiguration.setInstanceCount(config.getInstanceCount());
        this.marshallingConfiguration.setObjectResolver(config.getObjectResolver());
        this.marshallingConfiguration.setObjectTable(config.getObjectTable());
        this.marshallingConfiguration.setSerializabilityChecker((SerializabilityChecker)this.serializabilityChecker);
        this.marshallingConfiguration.setSerializedCreator(config.getSerializedCreator());
        this.marshallingConfiguration.setStreamHeader(config.getStreamHeader());
        this.marshallingConfiguration.setVersion(config.getVersion());
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    @Override
    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfiguration;
    }

    public void addMemberPassivationManager(PassivationManager<K, V> passivationManager) {
        SerializabilityChecker checker = passivationManager.getMarshallingConfiguration().getSerializabilityChecker();
        if (checker != null) {
            this.serializabilityChecker.addSerializabilityChecker(checker);
        }
    }

    @Override
    public Cacheable<UUID> createInstance() {
        return null;
    }

    @Override
    public void destroyInstance(Cacheable<UUID> instance) {
    }

    @Override
    public SerializationGroup<K, V, UUID> createEntry(Cacheable<UUID> item) {
        UUID key = null;
        while (!this.groupCache.hasAffinity(key = UUID.randomUUID())) {
        }
        SerializationGroupImpl<K, V> group = new SerializationGroupImpl<K, V>(key);
        group.setClustered(this.clustered);
        group.setGroupCache(this.groupCache);
        return group;
    }

    @Override
    public void destroyEntry(SerializationGroup<K, V, UUID> group) {
    }

    @Override
    public void postActivate(SerializationGroup<K, V, UUID> group) {
        log.tracef("postActivate(%s)", group);
        group.setGroupCache(this.groupCache);
        group.postActivate();
    }

    @Override
    public void prePassivate(SerializationGroup<K, V, UUID> group) {
        log.tracef("prePassivate(%s)", group);
        group.prePassivate();
    }

    @Override
    public void postReplicate(SerializationGroup<K, V, UUID> group) {
        log.tracef("postReplicate(%s)", group);
        group.setGroupCache(this.groupCache);
        group.postReplicate();
    }

    @Override
    public void preReplicate(SerializationGroup<K, V, UUID> group) {
        log.tracef("preReplicate(%s)", group);
        group.preReplicate();
    }

    public PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> getGroupCache() {
        return this.groupCache;
    }

    public void setGroupCache(PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache) {
        this.groupCache = groupCache;
    }
}

