/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.remote.DefaultEjbClientContextService;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class EjbClientContextSetupProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbClientContextSetupProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        EJBClientContext ejbClientContext = this.getEJBClientContext(phaseContext);
        ServiceController tcclEJBClientContextSelectorServiceController = phaseContext.getServiceRegistry().getService(TCCLEJBClientContextSelectorService.TCCL_BASED_EJB_CLIENT_CONTEXT_SELECTOR_SERVICE_NAME);
        if (tcclEJBClientContextSelectorServiceController != null) {
            TCCLEJBClientContextSelectorService tcclBasedEJBClientContextSelector = (TCCLEJBClientContextSelectorService)tcclEJBClientContextSelectorServiceController.getValue();
            logger.debug((Object)("Registering EJB client context " + ejbClientContext + " for classloader " + module.getClassLoader()));
            tcclBasedEJBClientContextSelector.registerEJBClientContext(ejbClientContext, (ClassLoader)module.getClassLoader());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private EJBClientContext getEJBClientContext(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeploymentUnit = deploymentUnit.getParent();
        EJBClientContext ejbClientContext = parentDeploymentUnit != null ? (EJBClientContext)parentDeploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT) : (EJBClientContext)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT);
        if (ejbClientContext != null) {
            return ejbClientContext;
        }
        logger.debug((Object)("Deployment unit " + deploymentUnit + " doesn't have any explicit EJB client context configured. " + "Falling back on the default " + DefaultEjbClientContextService.DEFAULT_SERVICE_NAME + " EJB client context service"));
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        ServiceController ejbClientContextServiceController = serviceRegistry.getRequiredService(DefaultEjbClientContextService.DEFAULT_SERVICE_NAME);
        return (EJBClientContext)ejbClientContextServiceController.getValue();
    }
}

