/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.xa.XAException;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryCollector;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.utils.DescriptorUtils;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.interceptors.AsyncInvocationTask;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.network.ClientMapping;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.TransactionID;
import org.jboss.invocation.InterceptorContext;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClassLoaderClassCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectCloners;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class LocalEjbReceiver
extends EJBReceiver
implements Service<LocalEjbReceiver>,
RegistryCollector.Listener<String, List<ClientMapping>> {
    public static final ServiceName DEFAULT_LOCAL_EJB_RECEIVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"default-local-ejb-receiver-service"});
    public static final ServiceName BY_VALUE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "localEjbReceiver", "value"});
    public static final ServiceName BY_REFERENCE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "localEjbReceiver", "reference"});
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final List<EJBReceiverContext> contexts = new CopyOnWriteArrayList<EJBReceiverContext>();
    private final InjectedValue<DeploymentRepository> deploymentRepository = new InjectedValue();
    private final InjectedValue<RegistryCollector> clusterRegistryCollector = new InjectedValue();
    private final Listener deploymentListener = new Listener();
    private final boolean allowPassByReference;

    public LocalEjbReceiver(String nodeName, boolean allowPassByReference) {
        super(nodeName);
        this.allowPassByReference = allowPassByReference;
    }

    protected void associate(EJBReceiverContext context) {
        this.contexts.add(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processInvocation(EJBClientInvocationContext invocation, EJBReceiverInvocationContext receiverContext) throws Exception {
        Object result;
        Object[] parameters;
        EJBLocator locator = invocation.getLocator();
        EjbDeploymentInformation ejb = this.findBean(locator.getAppName(), locator.getModuleName(), locator.getDistinctName(), locator.getBeanName());
        EJBComponent ejbComponent = ejb.getEjbComponent();
        Class viewClass = invocation.getViewClass();
        final ComponentView view = ejb.getView(viewClass.getName());
        if (view == null) {
            throw new RuntimeException("Could not find view " + viewClass + " for ejb " + ejb.getEjbName());
        }
        ClonerConfiguration paramConfig = new ClonerConfiguration();
        paramConfig.setClassCloner((ClassCloner)new ClassLoaderClassCloner(ejb.getDeploymentClassLoader()));
        ObjectCloner parameterCloner = ObjectCloners.getSerializingObjectClonerFactory().createCloner(paramConfig);
        Method method = view.getMethod(invocation.getInvokedMethod().getName(), DescriptorUtils.methodDescriptor((Method)invocation.getInvokedMethod()));
        boolean async = view.isAsynchronous(method);
        if (invocation.getParameters() == null) {
            parameters = EMPTY_OBJECT_ARRAY;
        } else {
            parameters = new Object[invocation.getParameters().length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.clone(method.getParameterTypes()[i], parameterCloner, invocation.getParameters()[i], this.allowPassByReference);
            }
        }
        final InterceptorContext context = new InterceptorContext();
        context.setParameters(parameters);
        context.setMethod(method);
        context.setTarget(invocation.getInvokedProxy());
        context.setContextData(new HashMap());
        context.putPrivateData(Component.class, (Object)ejbComponent);
        context.putPrivateData(ComponentView.class, (Object)view);
        if (locator instanceof StatefulEJBLocator) {
            SessionID sessionID = ((StatefulEJBLocator)locator).getSessionId();
            context.putPrivateData(SessionID.class, (Object)sessionID);
        } else if (locator instanceof EntityEJBLocator) {
            Object primaryKey = ((EntityEJBLocator)locator).getPrimaryKey();
            context.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKey);
        }
        ClonerConfiguration config = new ClonerConfiguration();
        config.setClassCloner((ClassCloner)new ClassLoaderClassCloner(invocation.getInvokedProxy().getClass().getClassLoader()));
        ObjectCloner resultCloner = ObjectCloners.getSerializingObjectClonerFactory().createCloner(config);
        if (async) {
            if (!(ejbComponent instanceof SessionBeanComponent)) throw new RuntimeException("Cannot perform asynchronous local invocation for component that is not a session bean");
            SessionBeanComponent component = (SessionBeanComponent)ejbComponent;
            CancellationFlag flag = new CancellationFlag();
            AsyncInvocationTask task = new AsyncInvocationTask(flag){

                @Override
                protected Object runInvocation() throws Exception {
                    return view.invoke(context);
                }
            };
            context.putPrivateData(CancellationFlag.class, (Object)flag);
            component.getAsynchronousExecutor().submit(task);
            receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new ImmediateResultProducer(task));
            return;
        }
        try {
            result = view.invoke(context);
        }
        catch (Exception e) {
            throw (Exception)this.clone(resultCloner, e);
        }
        Object clonedResult = this.clone(invocation.getInvokedMethod().getReturnType(), resultCloner, result, this.allowPassByReference);
        receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new ImmediateResultProducer(clonedResult));
    }

    protected <T> StatefulEJBLocator<T> openSession(EJBReceiverContext context, Class<T> viewType, String appName, String moduleName, String distinctName, String beanName) throws IllegalArgumentException {
        EjbDeploymentInformation ejbInfo = this.findBean(appName, moduleName, distinctName, beanName);
        EJBComponent component = ejbInfo.getEjbComponent();
        if (!(component instanceof StatefulSessionComponent)) {
            throw new IllegalArgumentException("EJB " + beanName + " is not a Stateful Session bean in app: " + appName + " module: " + moduleName + " distinct name:" + distinctName);
        }
        StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
        SessionID sessionID = statefulComponent.createSession();
        return new StatefulEJBLocator(viewType, appName, moduleName, beanName, distinctName, sessionID, statefulComponent.getCache().getStrictAffinity(), this.getNodeName());
    }

    private Object clone(Class<?> target, ObjectCloner cloner, Object object, boolean allowPassByReference) {
        if (object == null) {
            return null;
        }
        if (target.isPrimitive()) {
            return object;
        }
        if (allowPassByReference && target.isAssignableFrom(object.getClass())) {
            return object;
        }
        return this.clone(cloner, object);
    }

    private Object clone(ObjectCloner cloner, Object object) {
        if (object == null) {
            return null;
        }
        try {
            return cloner.clone(object);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException marshaling EJB parameters", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ClassNotFoundException marshaling EJB parameters", e);
        }
    }

    protected boolean exists(String appName, String moduleName, String distinctName, String beanName) {
        try {
            EjbDeploymentInformation ejbDeploymentInformation = this.findBean(appName, moduleName, distinctName, beanName);
            return ejbDeploymentInformation != null;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    protected int sendPrepare(EJBReceiverContext context, TransactionID transactionID) throws XAException {
        return 0;
    }

    protected void sendCommit(EJBReceiverContext context, TransactionID transactionID, boolean onePhase) throws XAException {
    }

    protected void sendRollback(EJBReceiverContext context, TransactionID transactionID) throws XAException {
    }

    protected void sendForget(EJBReceiverContext context, TransactionID transactionID) throws XAException {
    }

    protected void beforeCompletion(EJBReceiverContext context, TransactionID transactionID) {
    }

    private EjbDeploymentInformation findBean(String appName, String moduleName, String distinctName, String beanName) {
        ModuleDeployment module = ((DeploymentRepository)this.deploymentRepository.getValue()).getModules().get(new DeploymentModuleIdentifier(appName, moduleName, distinctName));
        if (module == null) {
            throw new IllegalArgumentException("Could not find module app: " + appName + " module: " + moduleName + " distinct name:" + distinctName);
        }
        EjbDeploymentInformation ejbInfo = module.getEjbs().get(beanName);
        if (ejbInfo == null) {
            throw new IllegalArgumentException("Could not find ejb " + beanName + " in app: " + appName + " module: " + moduleName + " distinct name:" + distinctName);
        }
        return ejbInfo;
    }

    public void start(StartContext context) throws StartException {
        ((DeploymentRepository)this.deploymentRepository.getValue()).addListener(this.deploymentListener);
        RegistryCollector collector = (RegistryCollector)this.clusterRegistryCollector.getValue();
        collector.addListener((RegistryCollector.Listener)this);
    }

    public void stop(StopContext context) {
        for (EJBReceiverContext ctx : this.contexts) {
            ctx.close();
        }
        this.contexts.clear();
        ((DeploymentRepository)this.deploymentRepository.getValue()).removeListener(this.deploymentListener);
        RegistryCollector collector = (RegistryCollector)this.clusterRegistryCollector.getValue();
        collector.removeListener((RegistryCollector.Listener)this);
    }

    public LocalEjbReceiver getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public void registryAdded(Registry<String, List<ClientMapping>> registry) {
        String clusterName = registry.getName();
        for (EJBReceiverContext receiverContext : this.contexts) {
            ClusterContext clusterContext = receiverContext.getClientContext().getOrCreateClusterContext(clusterName);
            clusterContext.addClusterNode(this.getNodeName(), (ClusterNodeManager)new LocalClusterNodeManager());
        }
    }

    public void registryRemoved(Registry<String, List<ClientMapping>> registry) {
    }

    public Injector<RegistryCollector> getClusterRegistryCollectorInjector() {
        return this.clusterRegistryCollector;
    }

    private class LocalClusterNodeManager
    implements ClusterNodeManager {
        private LocalClusterNodeManager() {
        }

        public String getNodeName() {
            return LocalEjbReceiver.this.getNodeName();
        }

        public EJBReceiver getEJBReceiver() {
            return LocalEjbReceiver.this;
        }
    }

    private class Listener
    implements DeploymentRepositoryListener {
        private Listener() {
        }

        @Override
        public void listenerAdded(DeploymentRepository repository) {
            for (Map.Entry<DeploymentModuleIdentifier, ModuleDeployment> entry : repository.getModules().entrySet()) {
                DeploymentModuleIdentifier module = entry.getKey();
                LocalEjbReceiver.this.registerModule(module.getApplicationName(), module.getModuleName(), module.getDistinctName());
            }
        }

        @Override
        public void deploymentAvailable(DeploymentModuleIdentifier deployment, ModuleDeployment moduleDeployment) {
            LocalEjbReceiver.this.registerModule(deployment.getApplicationName(), deployment.getModuleName(), deployment.getDistinctName());
        }

        @Override
        public void deploymentRemoved(DeploymentModuleIdentifier deployment) {
            LocalEjbReceiver.this.deregisterModule(deployment.getApplicationName(), deployment.getModuleName(), deployment.getDistinctName());
        }
    }

    private static class ImmediateResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Object clonedResult;

        public ImmediateResultProducer(Object clonedResult) {
            this.clonedResult = clonedResult;
        }

        public Object getResult() throws Exception {
            return this.clonedResult;
        }

        public void discardResult() {
        }
    }
}

