/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryService;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class EJB3SubsystemDefaultCacheWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJB3SubsystemDefaultCacheWriteHandler SFSB_CACHE = new EJB3SubsystemDefaultCacheWriteHandler(CacheFactoryService.DEFAULT_SFSB_CACHE_SERVICE_NAME, null, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_CACHE);
    public static final EJB3SubsystemDefaultCacheWriteHandler CLUSTERED_SFSB_CACHE = new EJB3SubsystemDefaultCacheWriteHandler(CacheFactoryService.DEFAULT_CLUSTERED_SFSB_CACHE_SERVICE_NAME, CacheFactoryService.DEFAULT_SFSB_CACHE_SERVICE_NAME, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_CLUSTERED_SFSB_CACHE);
    private final ServiceName serviceName;
    private final ServiceName defaultServiceName;
    private final AttributeDefinition attribute;

    public EJB3SubsystemDefaultCacheWriteHandler(ServiceName serviceName, ServiceName defaultServiceName, AttributeDefinition attribute) {
        super(new AttributeDefinition[]{attribute});
        this.serviceName = serviceName;
        this.defaultServiceName = defaultServiceName;
        this.attribute = attribute;
    }

    protected void validateResolvedValue(String attributeName, ModelNode value) throws OperationFailedException {
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateCacheService(context, model, null);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateCacheService(context, restored, null);
    }

    void updateCacheService(OperationContext context, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName dependency;
        ModelNode cacheName = this.attribute.resolveModelAttribute(context, model);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController existingService = registry.getService(this.serviceName);
        if (existingService != null) {
            context.removeService(existingService);
        }
        ServiceName serviceName = dependency = cacheName.isDefined() ? CacheFactoryService.getServiceName(cacheName.asString()) : this.defaultServiceName;
        if (dependency != null) {
            InjectedValue factory = new InjectedValue();
            ValueService service = new ValueService((Value)factory);
            ServiceController newController = context.getServiceTarget().addService(this.serviceName, (Service)service).addDependency(dependency, CacheFactory.class, (Injector)factory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            if (newControllers != null) {
                newControllers.add(newController);
            }
        }
    }
}

