/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ProtocolUtils;

class OperationAttachmentsProxy
implements OperationAttachments {
    final List<ProxiedInputStream> proxiedStreams;

    public OperationAttachmentsProxy(ManagementChannelAssociation channelAssociation, int batchId, int size) {
        this.proxiedStreams = new ArrayList<ProxiedInputStream>(size);
        for (int i = 0; i < size; ++i) {
            this.proxiedStreams.add(new ProxiedInputStream(channelAssociation, batchId, i));
        }
    }

    static OperationAttachmentsProxy create(ManagementChannelAssociation channelAssociation, int batchId, int size) {
        return new OperationAttachmentsProxy(channelAssociation, batchId, size);
    }

    public boolean isAutoCloseStreams() {
        return false;
    }

    public List<InputStream> getInputStreams() {
        ArrayList<ProxiedInputStream> result = new ArrayList<ProxiedInputStream>();
        result.addAll(this.proxiedStreams);
        return Collections.unmodifiableList(result);
    }

    public void close() throws IOException {
    }

    void shutdown(Exception error) {
        for (ProxiedInputStream stream : this.proxiedStreams) {
            stream.shutdown(error);
        }
    }

    public static class ProxiedInputStream
    extends InputStream {
        final ManagementChannelAssociation channelAssociation;
        final int batchId;
        final int index;
        volatile byte[] bytes;
        volatile ByteArrayInputStream delegate;
        volatile Exception error;

        ProxiedInputStream(ManagementChannelAssociation channelAssociation, int batchId, int index) {
            this.channelAssociation = channelAssociation;
            this.batchId = batchId;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.delegate == null) {
                ProxiedInputStream proxiedInputStream = this;
                synchronized (proxiedInputStream) {
                    if (this.delegate == null) {
                        this.initializeBytes();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw ControllerMessages.MESSAGES.remoteCallerThreadInterrupted();
                        }
                        if (this.error != null) {
                            if (this.error instanceof IOException) {
                                throw (IOException)this.error;
                            }
                            throw new IOException(this.error);
                        }
                        this.delegate = new ByteArrayInputStream(this.bytes);
                        this.bytes = null;
                    }
                }
            }
            return this.delegate.read();
        }

        void initializeBytes() {
            if (this.bytes == null) {
                try {
                    this.channelAssociation.executeRequest(Integer.valueOf(this.batchId), (ManagementRequest)new AbstractManagementRequest<Object, Object>(){

                        public byte getOperationType() {
                            return 76;
                        }

                        protected void sendRequest(ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<Object> context, FlushableDataOutput output) throws IOException {
                            output.write(102);
                            output.writeInt(ProxiedInputStream.this.index);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<Object> context) throws IOException {
                            ProxiedInputStream proxiedInputStream = ProxiedInputStream.this;
                            synchronized (proxiedInputStream) {
                                ProtocolUtils.expectHeader((DataInput)input, (int)103);
                                int size = input.readInt();
                                ProtocolUtils.expectHeader((DataInput)input, (int)104);
                                byte[] buf = new byte[size];
                                for (int i = 0; i < size; ++i) {
                                    buf[i] = input.readByte();
                                }
                                ProxiedInputStream.this.bytes = buf;
                                ProxiedInputStream.this.notifyAll();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    this.error = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown(Exception error) {
            this.error = error;
            ProxiedInputStream proxiedInputStream = this;
            synchronized (proxiedInputStream) {
                this.notifyAll();
            }
        }
    }
}

