/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.metadata.AbstractHandlerChainsMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.metadata.config.Feature;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public class ConfigMetaDataParser
extends AbstractHandlerChainsMetaDataParser {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ConfigMetaDataParser.class);

    private ConfigMetaDataParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigRoot parse(URL url) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
            ConfigRoot configRoot = ConfigMetaDataParser.parse(is);
            return configRoot;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static ConfigRoot parse(InputStream is) throws IOException {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return ConfigMetaDataParser.parse(xmlr);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public static ConfigRoot parse(XMLStreamReader reader) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        ConfigRoot configRoot = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "jaxws-config")) {
                    ConfigMetaDataParser parser = new ConfigMetaDataParser();
                    configRoot = parser.parseConfigRoot(reader);
                    break;
                }
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
            }
        }
        return configRoot;
    }

    private ConfigRoot parseConfigRoot(XMLStreamReader reader) throws XMLStreamException {
        ConfigRoot configRoot = new ConfigRoot();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "jaxws-config")) {
                        return configRoot;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "endpoint-config")) {
                        EndpointConfig epConfig = new EndpointConfig();
                        this.parseConfig(reader, epConfig, "endpoint-config");
                        configRoot.addEndpointConfig(epConfig);
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "client-config")) {
                        ClientConfig clConfig = new ClientConfig();
                        this.parseConfig(reader, clConfig, "client-config");
                        configRoot.addClientConfig(clConfig);
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }

    private void parseConfig(XMLStreamReader reader, CommonConfig config, String configElement) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", configElement)) {
                        return;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    UnifiedHandlerChainsMetaData uhcmd;
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "config-name")) {
                        config.setConfigName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "pre-handler-chains")) {
                        uhcmd = this.parseHandlerChains(reader, "http://java.sun.com/xml/ns/javaee", "urn:jboss:jbossws-jaxws-config:4.0", "pre-handler-chains");
                        config.setPreHandlerChains(uhcmd.getHandlerChains());
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "post-handler-chains")) {
                        uhcmd = this.parseHandlerChains(reader, "http://java.sun.com/xml/ns/javaee", "urn:jboss:jbossws-jaxws-config:4.0", "post-handler-chains");
                        config.setPostHandlerChains(uhcmd.getHandlerChains());
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature")) {
                        config.setFeature(this.parseFeature(reader), true);
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property")) {
                        this.parseProperty(reader, config);
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }

    private void parseProperty(XMLStreamReader reader, CommonConfig config) throws XMLStreamException {
        String name = null;
        String value = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property")) {
                        if (name == null) {
                            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_GET_PROPERTY_NAME", (Object[])new Object[0]));
                        }
                        config.setProperty(name, value);
                        return;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property-name")) {
                        name = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property-value")) {
                        value = StAXUtils.elementAsString(reader);
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }

    private Feature parseFeature(XMLStreamReader reader) throws XMLStreamException {
        Feature feature = null;
        block4: while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature")) {
                        if (feature == null) {
                            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_READ_FEATURE_NAME", (Object[])new Object[0]));
                        }
                        return feature;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature-name")) {
                        feature = new Feature(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature-data")) {
                        Logger.getLogger(this.getClass()).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FEATURE_DATA_NOT_SUPPORTED_YET", (Object[])new Object[0]));
                        while (reader.hasNext()) {
                            reader.next();
                            if (!reader.isEndElement() || !StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature-data")) continue;
                            break block0;
                        }
                        continue block4;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }
}

