/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.subsystem.CommonAttributes;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemAdd;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackAdd;
import org.jboss.as.clustering.jgroups.subsystem.StackConfigOperationHandlers;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class JGroupsSubsystemDescribe
implements OperationStepHandler {
    public static final JGroupsSubsystemDescribe INSTANCE = new JGroupsSubsystemDescribe();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = new ModelNode();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        result.add(JGroupsSubsystemAdd.createOperation(rootAddress.toModelNode(), subModel));
        if (subModel.hasDefined("stack")) {
            for (Property stack : subModel.get("stack").asPropertyList()) {
                ModelNode stackAddress = rootAddress.toModelNode();
                stackAddress.add("stack", stack.getName());
                result.add(ProtocolStackAdd.createOperation(stackAddress, stack.getValue()));
                if (stack.getValue().get(new String[]{"transport", "TRANSPORT"}).isDefined()) {
                    ModelNode transport = stack.getValue().get(new String[]{"transport", "TRANSPORT"});
                    ModelNode transportAddress = stackAddress.clone();
                    transportAddress.add("transport", "TRANSPORT");
                    result.add(StackConfigOperationHandlers.createOperation(CommonAttributes.TRANSPORT_ATTRIBUTES, transportAddress, transport));
                    this.addProtocolPropertyCommands(transport, transportAddress, result);
                }
                if (!stack.getValue().get("protocol").isDefined()) continue;
                for (Property protocol : ProtocolStackAdd.getOrderedProtocolPropertyList(stack.getValue())) {
                    result.add(StackConfigOperationHandlers.createProtocolOperation(CommonAttributes.PROTOCOL_ATTRIBUTES, stackAddress, protocol.getValue()));
                    ModelNode protocolAddress = stackAddress.clone();
                    protocolAddress.add("protocol", protocol.getName());
                    this.addProtocolPropertyCommands(protocol.getValue(), protocolAddress, result);
                }
            }
        }
        context.getResult().set(result);
        context.completeStep();
    }

    private void addProtocolPropertyCommands(ModelNode protocol, ModelNode address, ModelNode result) throws OperationFailedException {
        if (protocol.hasDefined("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                ModelNode propertyAddress = address.clone().add("property", property.getName());
                AttributeDefinition[] ATTRIBUTE = new AttributeDefinition[]{CommonAttributes.VALUE};
                result.add(StackConfigOperationHandlers.createOperation(ATTRIBUTE, propertyAddress, property.getValue()));
            }
        }
    }
}

