/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import java.util.ArrayList;
import javax.ejb.ConcurrencyManagementType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AroundTimeoutMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AsyncMethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.ConcurrentMethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.DependsOnMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.NamedMethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.SessionBean30MetaDataParser;
import org.jboss.metadata.ejb.parser.spec.StatefulTimeoutMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.TimerMetaDataParser;
import org.jboss.metadata.ejb.spec.AbstractGenericBeanMetaData;
import org.jboss.metadata.ejb.spec.AroundTimeoutMetaData;
import org.jboss.metadata.ejb.spec.AroundTimeoutsMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.DependsOnMetaData;
import org.jboss.metadata.ejb.spec.EjbType;
import org.jboss.metadata.ejb.spec.GenericBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class SessionBean31MetaDataParser
extends SessionBean30MetaDataParser {
    @Override
    protected void processElement(AbstractGenericBeanMetaData sessionBean, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case LOCAL_BEAN: {
                reader.getElementText();
                sessionBean.setNoInterfaceBean(true);
                return;
            }
            case CONCURRENCY_MANAGEMENT_TYPE: {
                String concurrencyManagementType = SessionBean31MetaDataParser.getElementText((XMLStreamReader)reader);
                if (concurrencyManagementType.equals("Bean")) {
                    sessionBean.setConcurrencyManagementType(ConcurrencyManagementType.BEAN);
                } else if (concurrencyManagementType.equals("Container")) {
                    sessionBean.setConcurrencyManagementType(ConcurrencyManagementType.CONTAINER);
                } else {
                    throw SessionBean31MetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected value: " + concurrencyManagementType + " for concurrency-management-type"));
                }
                return;
            }
            case CONCURRENT_METHOD: {
                if (sessionBean.getConcurrentMethods() == null) {
                    sessionBean.setConcurrentMethods(new ConcurrentMethodsMetaData());
                }
                sessionBean.getConcurrentMethods().add(ConcurrentMethodMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case ASYNC_METHOD: {
                if (sessionBean.getAsyncMethods() == null) {
                    sessionBean.setAsyncMethods(new AsyncMethodsMetaData());
                }
                sessionBean.getAsyncMethods().add(AsyncMethodMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case DEPENDS_ON: {
                DependsOnMetaData dependsOn = DependsOnMetaDataParser.INSTANCE.parse(reader);
                sessionBean.setDependsOnMetaData(dependsOn);
                return;
            }
            case STATEFUL_TIMEOUT: {
                StatefulTimeoutMetaData statefulTimeout = StatefulTimeoutMetaDataParser.INSTANCE.parse(reader);
                sessionBean.setStatefulTimeout(statefulTimeout);
                return;
            }
            case INIT_ON_STARTUP: {
                String initOnStartup = SessionBean31MetaDataParser.getElementText((XMLStreamReader)reader);
                if (initOnStartup == null) {
                    throw SessionBean31MetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected null value for init-on-startup element"));
                }
                sessionBean.setInitOnStartup(Boolean.parseBoolean(initOnStartup));
                return;
            }
            case AFTER_BEGIN_METHOD: {
                sessionBean.setAfterBeginMethod(NamedMethodMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case BEFORE_COMPLETION_METHOD: {
                sessionBean.setBeforeCompletionMethod(NamedMethodMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case AFTER_COMPLETION_METHOD: {
                sessionBean.setAfterCompletionMethod(NamedMethodMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case AROUND_TIMEOUT: {
                AroundTimeoutsMetaData aroundTimeouts = sessionBean.getAroundTimeouts();
                if (aroundTimeouts == null) {
                    aroundTimeouts = new AroundTimeoutsMetaData();
                    sessionBean.setAroundTimeouts(aroundTimeouts);
                }
                AroundTimeoutMetaData aroundInvoke = AroundTimeoutMetaDataParser.INSTANCE.parse(reader);
                aroundTimeouts.add(aroundInvoke);
                break;
            }
            case TIMER: {
                ArrayList<TimerMetaData> timers = sessionBean.getTimers();
                if (timers == null) {
                    timers = new ArrayList<TimerMetaData>();
                    sessionBean.setTimers(timers);
                }
                TimerMetaData timerMetaData = TimerMetaDataParser.INSTANCE.parse(reader);
                timers.add(timerMetaData);
                return;
            }
            default: {
                super.processElement(sessionBean, reader);
                return;
            }
        }
    }

    @Override
    protected AbstractGenericBeanMetaData createSessionBeanMetaData() {
        return new GenericBeanMetaData(EjbType.SESSION);
    }

    @Override
    protected SessionType processSessionType(String sessionType) {
        if (sessionType.equals("Singleton")) {
            return SessionType.Singleton;
        }
        return super.processSessionType(sessionType);
    }
}

