/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader setThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl, true);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl, true);
    }

    static void resetThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl, false);
        } else {
            SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl, false);
        }
    }

    private static interface SetThreadContextClassLoaderAction {
        public static final SetThreadContextClassLoaderAction NON_PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(ClassLoader cl, boolean get) {
                ClassLoader old = get ? Thread.currentThread().getContextClassLoader() : null;
                Thread.currentThread().setContextClassLoader(cl);
                return old;
            }
        };
        public static final SetThreadContextClassLoaderAction PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(final ClassLoader cl, final boolean get) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = get ? Thread.currentThread().getContextClassLoader() : null;
                        Thread.currentThread().setContextClassLoader(cl);
                        return old;
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(ClassLoader var1, boolean var2);
    }
}

