/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldSubsystemAdd;
import org.jboss.as.weld.WeldSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class WeldExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "weld";
    public static final String NAMESPACE = "urn:jboss:domain:weld:1.0";
    private static final WeldSubsystemParser parser = new WeldSubsystemParser();
    static final DescriptionProvider SUBSYSTEM_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return WeldSubsystemProviders.getSubsystemDescription(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return WeldSubsystemProviders.getSubsystemAddDescription(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_REMOVE_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return WeldSubsystemProviders.getSubsystemRemoveDescription(locale);
        }
    };

    public void initialize(ExtensionContext context) {
        WeldLogger.ROOT_LOGGER.debug("Activating Weld Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(SUBSYSTEM_DESCRIPTION);
        registration.registerOperationHandler("add", (OperationStepHandler)WeldSubsystemAdd.INSTANCE, SUBSYSTEM_ADD_DESCRIPTION, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WeldSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)WeldSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, SUBSYSTEM_REMOVE_DESCRIPTION, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)parser);
    }

    private static ModelNode createAddSubSystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class WeldSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final WeldSubsystemDescribeHandler INSTANCE = new WeldSubsystemDescribeHandler();

        private WeldSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.getResult().add(WeldExtension.createAddSubSystemOperation());
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class WeldSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        WeldSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            list.add(WeldExtension.createAddSubSystemOperation());
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(WeldExtension.NAMESPACE, false);
            streamWriter.writeEndElement();
        }
    }
}

