/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.XsdString;

public class AdminObjectImpl
implements AdminObject {
    private static final long serialVersionUID = -7653991400977178783L;
    private final XsdString adminobjectInterface;
    private final XsdString adminobjectClass;
    private ArrayList<ConfigProperty> configProperties;
    private final String id;

    public AdminObjectImpl(XsdString adminobjectInterface, XsdString adminobjectClass, List<? extends ConfigProperty> configProperty, String id) {
        this.adminobjectInterface = adminobjectInterface;
        this.adminobjectClass = adminobjectClass;
        if (configProperty != null) {
            this.configProperties = new ArrayList(configProperty.size());
            this.configProperties.addAll(configProperty);
        } else {
            this.configProperties = new ArrayList(0);
        }
        this.id = id;
    }

    public XsdString getAdminobjectInterface() {
        return this.adminobjectInterface;
    }

    public XsdString getAdminobjectClass() {
        return this.adminobjectClass;
    }

    public synchronized List<? extends ConfigProperty> getConfigProperties() {
        return this.configProperties == null ? null : Collections.unmodifiableList(this.configProperties);
    }

    public synchronized void forceNewConfigPropertiesContent(List<? extends ConfigProperty> newContents) {
        if (newContents != null) {
            this.configProperties = new ArrayList(newContents.size());
            this.configProperties.addAll(newContents);
        } else {
            this.configProperties = new ArrayList(0);
        }
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminobjectClass == null ? 0 : this.adminobjectClass.hashCode());
        result = 31 * result + (this.adminobjectInterface == null ? 0 : this.adminobjectInterface.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminObjectImpl)) {
            return false;
        }
        AdminObjectImpl other = (AdminObjectImpl)obj;
        if (this.adminobjectClass == null ? other.adminobjectClass != null : !this.adminobjectClass.equals((Object)other.adminobjectClass)) {
            return false;
        }
        if (this.adminobjectInterface == null ? other.adminobjectInterface != null : !this.adminobjectInterface.equals((Object)other.adminobjectInterface)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<adminobject");
        if (this.id != null) {
            sb.append(" ").append(AdminObject.Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        sb.append("<").append(AdminObject.Tag.ADMINOBJECT_INTERFACE).append(">");
        sb.append(this.adminobjectInterface);
        sb.append("</").append(AdminObject.Tag.ADMINOBJECT_INTERFACE).append(">");
        sb.append("<").append(AdminObject.Tag.ADMINOBJECT_CLASS).append(">");
        sb.append(this.adminobjectClass);
        sb.append("</").append(AdminObject.Tag.ADMINOBJECT_CLASS).append(">");
        if (this.configProperties != null) {
            for (ConfigProperty cp : this.configProperties) {
                sb.append(cp);
            }
        }
        sb.append("</adminobject>");
        return sb.toString();
    }

    public CopyableMetaData copy() {
        return new AdminObjectImpl((XsdString)CopyUtil.clone((CopyableMetaData)this.adminobjectInterface), (XsdString)CopyUtil.clone((CopyableMetaData)this.adminobjectClass), CopyUtil.cloneList(this.configProperties), CopyUtil.cloneString((String)this.id));
    }
}

