/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.osgi.resolver.v2.XAttachmentSupport;
import org.jboss.osgi.resolver.v2.XAttributeSupport;
import org.jboss.osgi.resolver.v2.XDirectiveSupport;
import org.jboss.osgi.resolver.v2.XElement;

class AbstractElement
implements XElement {
    private XAttachmentSupport attachments;

    AbstractElement() {
    }

    @Override
    public <T> T addAttachment(Class<T> clazz, T value) {
        if (this.attachments == null) {
            this.attachments = new AttachmentSupporter();
        }
        return this.attachments.addAttachment(clazz, value);
    }

    @Override
    public <T> T getAttachment(Class<T> clazz) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.getAttachment(clazz);
    }

    @Override
    public <T> T removeAttachment(Class<T> clazz) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.removeAttachment(clazz);
    }

    static class DirectiveSupporter
    implements XDirectiveSupport {
        private Map<String, String> directives;

        DirectiveSupporter(Map<String, String> directives) {
            this.directives = directives;
        }

        @Override
        public String getDirective(String key) {
            return this.directives != null ? this.directives.get(key) : null;
        }

        @Override
        public Map<String, String> getDirectives() {
            return this.directives != null ? Collections.unmodifiableMap(this.directives) : Collections.emptyMap();
        }

        public String toString() {
            return this.getDirectives().toString();
        }
    }

    static class AttributeSupporter
    implements XAttributeSupport {
        private Map<String, Object> attributes;

        AttributeSupporter(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        @Override
        public Object getAttribute(String key) {
            return this.attributes != null ? this.attributes.get(key) : null;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attributes != null ? Collections.unmodifiableMap(this.attributes) : Collections.emptyMap();
        }

        public String toString() {
            return this.getAttributes().toString();
        }
    }

    static class AttachmentSupporter
    implements XAttachmentSupport {
        private Map<Class<?>, Object> attachments;

        AttachmentSupporter() {
        }

        @Override
        public <T> T addAttachment(Class<T> clazz, T value) {
            if (this.attachments == null) {
                this.attachments = new HashMap();
            }
            Object result = this.attachments.get(clazz);
            this.attachments.put(clazz, value);
            return (T)result;
        }

        @Override
        public <T> T getAttachment(Class<T> clazz) {
            if (this.attachments == null) {
                return null;
            }
            Object result = this.attachments.get(clazz);
            return (T)result;
        }

        @Override
        public <T> T removeAttachment(Class<T> clazz) {
            if (this.attachments == null) {
                return null;
            }
            Object result = this.attachments.remove(clazz);
            return (T)result;
        }
    }
}

