/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.dmr.ModelNode;

abstract class AbstractPlatformMBeanResource
implements Resource.ResourceEntry {
    private final PathElement pathElement;

    AbstractPlatformMBeanResource(PathElement pathElement) {
        this.pathElement = pathElement;
    }

    public ModelNode getModel() {
        return new ModelNode();
    }

    public void writeModel(ModelNode newModel) {
        throw PlatformMBeanMessages.MESSAGES.modelNotWritable();
    }

    public boolean isModelDefined() {
        return false;
    }

    public Resource getChild(PathElement element) {
        if (this.hasChildren(element.getKey())) {
            return this.getChildEntry(element.getValue());
        }
        return null;
    }

    public Resource requireChild(PathElement address) {
        Resource resource = this.getChild(address);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(address);
        }
        return resource;
    }

    public Resource navigate(PathAddress address) {
        if (address.size() == 0) {
            return this;
        }
        Resource child = this.requireChild(address.getElement(0));
        return address.size() == 1 ? child : child.navigate(address.subAddress(1));
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if (!this.hasChildren(childType)) {
            return Collections.emptySet();
        }
        HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
        for (String name : this.getChildrenNames()) {
            result.add(this.getChildEntry(name));
        }
        return result;
    }

    public boolean hasChildren(String childType) {
        return this.getChildTypes().contains(childType);
    }

    public boolean hasChild(PathElement element) {
        return this.getChildrenNames(element.getKey()).contains(element.getValue());
    }

    public Set<String> getChildrenNames(String childType) {
        if (this.hasChildren(childType)) {
            return this.getChildrenNames();
        }
        return Collections.emptySet();
    }

    public void registerChild(PathElement address, Resource resource) {
        throw PlatformMBeanMessages.MESSAGES.addingChildrenNotSupported();
    }

    public Resource removeChild(PathElement address) {
        throw PlatformMBeanMessages.MESSAGES.removingChildrenNotSupported();
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        try {
            return (Resource)Resource.class.cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("impossible");
        }
    }

    public String getName() {
        return this.pathElement.getValue();
    }

    public PathElement getPathElement() {
        return this.pathElement;
    }

    abstract Resource.ResourceEntry getChildEntry(String var1);

    abstract Set<String> getChildrenNames();
}

