/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.AuthTokenV3Singleton;
import org.apache.ws.scout.registry.BulkResponseImpl;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerV3Impl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.IRegistryV3;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.RegistryV3Exception;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.util.EnumerationHelper;
import org.apache.ws.scout.util.ScoutJaxrUddiV3Helper;
import org.apache.ws.scout.util.ScoutUddiV3JaxrHelper;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.PublisherAssertions;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelList;

public class BusinessQueryManagerV3Impl
implements BusinessQueryManager {
    private final RegistryServiceImpl registryService;
    private Log log = LogFactory.getLog(this.getClass());
    private static ObjectFactory objectFactory = new ObjectFactory();

    public BusinessQueryManagerV3Impl(RegistryServiceImpl registry) {
        this.registryService = registry;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public BulkResponse findOrganizations(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
        try {
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerV3Impl.mapFindQualifiers(findQualifiers);
            Name[] nameArray = BusinessQueryManagerV3Impl.mapNamePatterns(namePatterns);
            BusinessList result = registry.findBusiness(nameArray, null, ScoutJaxrUddiV3Helper.getIdentifierBagFromExternalIdentifiers(externalIdentifiers), ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(classifications), ScoutJaxrUddiV3Helper.getTModelBagFromSpecifications(specifications), juddiFindQualifiers, this.registryService.getMaxRows());
            BusinessInfo[] bizInfoArr = null;
            BusinessInfos bizInfos = result.getBusinessInfos();
            LinkedHashSet<Organization> orgs = new LinkedHashSet<Organization>();
            if (bizInfos != null) {
                List bizInfoList = bizInfos.getBusinessInfo();
                for (BusinessInfo businessInfo : bizInfoList) {
                    BusinessDetail detail = registry.getBusinessDetail(businessInfo.getBusinessKey());
                    BusinessLifeCycleManagerV3Impl blcm = (BusinessLifeCycleManagerV3Impl)this.registryService.getLifeCycleManagerImpl();
                    orgs.add(blcm.createOrganization(detail));
                }
                bizInfoArr = new BusinessInfo[bizInfoList.size()];
                bizInfoList.toArray(bizInfoArr);
            }
            return new BulkResponseImpl(orgs);
        }
        catch (RegistryV3Exception e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse findAssociations(Collection findQualifiers, String sourceObjectId, String targetObjectId, Collection associationTypes) throws JAXRException {
        IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            PublisherAssertions result = null;
            try {
                result = registry.getPublisherAssertions(auth.getAuthInfo());
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(con.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                auth = this.getAuthToken(con, registry);
                result = registry.getPublisherAssertions(auth.getAuthInfo());
            }
            List publisherAssertionList = result.getPublisherAssertion();
            LinkedHashSet<Association> col = new LinkedHashSet<Association>();
            for (PublisherAssertion pas : publisherAssertionList) {
                String sourceKey = pas.getFromKey();
                String targetKey = pas.getToKey();
                ArrayList<KeyImpl> orgcol = new ArrayList<KeyImpl>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiV3JaxrHelper.getAssociation(bl.getCollection(), (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                KeyedReference keyr = pas.getKeyedReference();
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setValue(keyr.getKeyValue());
                asso.setAssociationType((Concept)c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryV3Exception e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse findCallerAssociations(Collection findQualifiers, Boolean confirmedByCaller, Boolean confirmedByOtherParty, Collection associationTypes) throws JAXRException {
        IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            AssertionStatusReport report = null;
            String confirm = "";
            boolean caller = confirmedByCaller;
            boolean other = confirmedByOtherParty;
            if (caller && other) {
                confirm = "status:complete";
            } else if (!caller && other) {
                confirm = "status:fromKey_incomplete";
            } else if (caller && !other) {
                confirm = "status:toKey_incomplete";
            }
            try {
                report = registry.getAssertionStatusReport(auth.getAuthInfo(), confirm);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(con.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                auth = this.getAuthToken(con, registry);
                report = registry.getAssertionStatusReport(auth.getAuthInfo(), confirm);
            }
            List assertionStatusItemList = report.getAssertionStatusItem();
            LinkedHashSet<Association> col = new LinkedHashSet<Association>();
            for (AssertionStatusItem asi : assertionStatusItemList) {
                String sourceKey = asi.getFromKey();
                String targetKey = asi.getToKey();
                ArrayList<KeyImpl> orgcol = new ArrayList<KeyImpl>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiV3JaxrHelper.getAssociation(bl.getCollection(), (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                ((AssociationImpl)asso).setConfirmedBySourceOwner(caller);
                ((AssociationImpl)asso).setConfirmedByTargetOwner(other);
                if (confirm != "status:complete") {
                    ((AssociationImpl)asso).setConfirmed(false);
                }
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                KeyedReference keyr = asi.getKeyedReference();
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setValue(keyr.getKeyValue());
                asso.setKey((Key)new KeyImpl(keyr.getTModelKey()));
                asso.setAssociationType((Concept)c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryV3Exception e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public ClassificationScheme findClassificationSchemeByName(Collection findQualifiers, String namePatterns) throws JAXRException {
        ClassificationSchemeImpl scheme = null;
        if (namePatterns.indexOf("uddi-org:types") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4"));
        } else if (namePatterns.indexOf("dnb-com:D-U-N-S") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("unspsc-org:unspsc") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
        } else if (namePatterns.indexOf("ntis-gov:naics") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2"));
        } else if ("AssociationType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "RelatedTo");
            this.addChildConcept(scheme, "HasChild");
            this.addChildConcept(scheme, "HasMember");
            this.addChildConcept(scheme, "HasParent");
            this.addChildConcept(scheme, "ExternallyLinks");
            this.addChildConcept(scheme, "Contains");
            this.addChildConcept(scheme, "EquivalentTo");
            this.addChildConcept(scheme, "Extends");
            this.addChildConcept(scheme, "Implements");
            this.addChildConcept(scheme, "InstanceOf");
            this.addChildConcept(scheme, "Supersedes");
            this.addChildConcept(scheme, "Uses");
            this.addChildConcept(scheme, "Replaces");
            this.addChildConcept(scheme, "ResponsibleFor");
            this.addChildConcept(scheme, "SubmitterOf");
        } else if ("ObjectType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "CPP");
            this.addChildConcept(scheme, "CPA");
            this.addChildConcept(scheme, "Process");
            this.addChildConcept(scheme, "WSDL");
            this.addChildConcept(scheme, "Association");
            this.addChildConcept(scheme, "AuditableEvent");
            this.addChildConcept(scheme, "Classification");
            this.addChildConcept(scheme, "Concept");
            this.addChildConcept(scheme, "ExternalIdentifier");
            this.addChildConcept(scheme, "ExternalLink");
            this.addChildConcept(scheme, "ExtrinsicObject");
            this.addChildConcept(scheme, "Organization");
            this.addChildConcept(scheme, "Package");
            this.addChildConcept(scheme, "Service");
            this.addChildConcept(scheme, "ServiceBinding");
            this.addChildConcept(scheme, "User");
        } else if ("PhoneType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "OfficePhone");
            this.addChildConcept(scheme, "HomePhone");
            this.addChildConcept(scheme, "MobilePhone");
            this.addChildConcept(scheme, "Beeper");
            this.addChildConcept(scheme, "FAX");
        } else if ("URLType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "HTTP");
            this.addChildConcept(scheme, "HTTPS");
            this.addChildConcept(scheme, "SMTP");
            this.addChildConcept(scheme, "PHONE");
            this.addChildConcept(scheme, "FAX");
            this.addChildConcept(scheme, "OTHER");
        } else if ("PostalAddressAttributes".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "StreetNumber");
            this.addChildConcept(scheme, "Street");
            this.addChildConcept(scheme, "City");
            this.addChildConcept(scheme, "State");
            this.addChildConcept(scheme, "PostalCode");
            this.addChildConcept(scheme, "Country");
        } else {
            IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerV3Impl.mapFindQualifiers(findQualifiers);
            try {
                TModelInfos infos;
                TModelList list = registry.findTModel(namePatterns, null, null, juddiFindQualifiers, 3);
                if (list != null && (infos = list.getTModelInfos()) != null) {
                    List tmodelInfoList = infos.getTModelInfo();
                    if (tmodelInfoList.size() > 1) {
                        throw new InvalidRequestException("Multiple matches found:" + tmodelInfoList.size());
                    }
                    if (tmodelInfoList.size() == 1) {
                        TModelInfo info = (TModelInfo)tmodelInfoList.get(0);
                        scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
                        scheme.setName(new InternationalStringImpl(info.getName().getValue()));
                        scheme.setKey(new KeyImpl(info.getTModelKey()));
                    }
                }
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return scheme;
    }

    private void addChildConcept(ClassificationSchemeImpl scheme, String name) throws JAXRException {
        ConceptImpl c = new ConceptImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
        c.setName(new InternationalStringImpl(name));
        c.setValue(name);
        c.setScheme(scheme);
        scheme.addChildConcept(c);
    }

    public BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        ClassificationScheme classificationScheme;
        LinkedHashSet<ClassificationScheme> col = new LinkedHashSet<ClassificationScheme>();
        Iterator iter = namePatterns.iterator();
        String name = "";
        if (iter.hasNext()) {
            name = (String)iter.next();
        }
        if ((classificationScheme = this.findClassificationSchemeByName(findQualifiers, name)) != null) {
            col.add(classificationScheme);
        }
        return new BulkResponseImpl(col);
    }

    public Concept findConceptByPath(String path) throws JAXRException {
        return EnumerationHelper.getConceptByPath(path);
    }

    public BulkResponse findConcepts(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        LinkedHashSet<Concept> col = new LinkedHashSet<Concept>();
        IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerV3Impl.mapFindQualifiers(findQualifiers);
        Iterator iter = null;
        if (namePatterns != null) {
            iter = namePatterns.iterator();
        }
        while (iter.hasNext()) {
            String namestr = (String)iter.next();
            try {
                List tmodelInfoList;
                TModelList list = registry.findTModel(namestr, ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(classifications), ScoutJaxrUddiV3Helper.getIdentifierBagFromExternalIdentifiers(externalIdentifiers), juddiFindQualifiers, 10);
                if (list == null || list.getTModelInfos() == null || (tmodelInfoList = list.getTModelInfos().getTModelInfo()) == null) continue;
                for (TModelInfo info : tmodelInfoList) {
                    col.add(ScoutUddiV3JaxrHelper.getConcept(info, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager()));
                }
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return new BulkResponseImpl(col);
    }

    public BulkResponse findRegistryPackages(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse findServiceBindings(Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistryV3 iRegistry = (IRegistryV3)this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerV3Impl.mapFindQualifiers(findQualifiers);
        try {
            BindingDetail bindingDetail = iRegistry.findBinding(serviceKey.getId(), ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(classifications), ScoutJaxrUddiV3Helper.getTModelBagFromSpecifications(specifications), juddiFindQualifiers, this.registryService.getMaxRows());
            if (bindingDetail != null) {
                List bindingTemplateList = bindingDetail.getBindingTemplate();
                BindingTemplate[] bindarr = new BindingTemplate[bindingTemplateList.size()];
                bindingTemplateList.toArray(bindarr);
                LinkedHashSet<ServiceBinding> col = new LinkedHashSet<ServiceBinding>();
                for (int i = 0; bindarr != null && i < bindarr.length; ++i) {
                    BindingTemplate si = bindarr[i];
                    ServiceBinding sb = ScoutUddiV3JaxrHelper.getServiceBinding(si, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                    col.add(sb);
                    Service s = (Service)this.getRegistryObject(serviceKey.getId(), "Service");
                    ((ServiceBindingImpl)sb).setService(s);
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryV3Exception e) {
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    public BulkResponse findServices(Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specificationa) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistryV3 iRegistry = (IRegistryV3)this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerV3Impl.mapFindQualifiers(findQualifiers);
        Name[] juddiNames = BusinessQueryManagerV3Impl.mapNamePatterns(namePatterns);
        try {
            ServiceList serviceList;
            String id = null;
            if (orgKey != null) {
                id = orgKey.getId();
            }
            if ((serviceList = iRegistry.findService(id, juddiNames, ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(classifications), null, juddiFindQualifiers, this.registryService.getMaxRows())) != null) {
                ServiceInfos serviceInfos = serviceList.getServiceInfos();
                LinkedHashSet<Service> col = new LinkedHashSet<Service>();
                if (serviceInfos != null && serviceInfos.getServiceInfo() != null) {
                    for (ServiceInfo si : serviceInfos.getServiceInfo()) {
                        Service srv = (Service)this.getRegistryObject(si.getServiceKey(), "Service");
                        col.add(srv);
                    }
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryV3Exception e) {
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    public RegistryObject getRegistryObject(String id) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryObject getRegistryObject(String id, String objectType) throws JAXRException {
        IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
        BusinessLifeCycleManager lcm = this.registryService.getBusinessLifeCycleManager();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(id);
                Concept c = ScoutUddiV3JaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
                ClassificationSchemeImpl scheme = new ClassificationSchemeImpl((LifeCycleManager)lcm);
                scheme.setName(c.getName());
                scheme.setDescription(c.getDescription());
                scheme.setKey(c.getKey());
                return scheme;
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            try {
                BusinessDetail orgdetail = registry.getBusinessDetail(id);
                return ScoutUddiV3JaxrHelper.getOrganization(orgdetail, (LifeCycleManager)lcm);
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(id);
                return ScoutUddiV3JaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Service".equalsIgnoreCase(objectType)) {
            try {
                Iterator i$;
                ServiceDetail sd = registry.getServiceDetail(id);
                if (sd != null && sd.getBusinessService() != null && (i$ = sd.getBusinessService().iterator()).hasNext()) {
                    BusinessService businessService = (BusinessService)i$.next();
                    Service service = this.getServiceFromBusinessService(businessService, (LifeCycleManager)lcm);
                    return service;
                }
            }
            catch (RegistryV3Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected Service getServiceFromBusinessService(BusinessService bs, LifeCycleManager lcm) throws JAXRException {
        ServiceImpl service = (ServiceImpl)ScoutUddiV3JaxrHelper.getService(bs, lcm);
        service.setSubmittingOrganizationKey(bs.getBusinessKey());
        return service;
    }

    public BulkResponse getRegistryObjects() throws JAXRException {
        String[] types = new String[]{"Organization", "Service"};
        LinkedHashSet c = new LinkedHashSet();
        for (int i = 0; i < types.length; ++i) {
            try {
                BulkResponse bk = this.getRegistryObjects(types[i]);
                if (bk.getCollection() == null) continue;
                c.addAll(bk.getCollection());
                continue;
            }
            catch (JAXRException e) {
                this.log.debug((Object)("ignore - just a problem with that type? " + e.getMessage()), (Throwable)e);
            }
        }
        return new BulkResponseImpl(c);
    }

    public BulkResponse getRegistryObjects(Collection objectKeys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BulkResponse getRegistryObjects(Collection objectKeys, String objectType) throws JAXRException {
        TModelDetail tmodeldetail;
        IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
        String[] keys = new String[objectKeys.size()];
        int currLoc = 0;
        for (Key key : objectKeys) {
            String keyString = key.getId();
            keys[currLoc++] = keyString;
        }
        LinkedHashSet<Object> col = new LinkedHashSet<Object>();
        BusinessLifeCycleManager lcm = this.registryService.getLifeCycleManagerImpl();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                tmodeldetail = registry.getTModelDetail(keys);
                List tmodelList = tmodeldetail.getTModel();
                for (TModel tModel : tmodelList) {
                    col.add(ScoutUddiV3JaxrHelper.getConcept(tModel, (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            try {
                BusinessInfos infos;
                RegisteredInfo ri = null;
                try {
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                catch (RegistryV3Exception rve) {
                    String username = this.getUsernameFromCredentials(con.getCredentials());
                    if (AuthTokenV3Singleton.getToken(username) != null) {
                        AuthTokenV3Singleton.deleteAuthToken(username);
                    }
                    auth = this.getAuthToken(con, registry);
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                if (ri == null || (infos = ri.getBusinessInfos()) == null) return new BulkResponseImpl(col);
                for (String key : keys) {
                    BusinessDetail detail = registry.getBusinessDetail(key);
                    col.add(((BusinessLifeCycleManagerV3Impl)this.registryService.getLifeCycleManagerImpl()).createOrganization(detail));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                tmodeldetail = registry.getTModelDetail(keys);
                List tmodelList = tmodeldetail.getTModel();
                for (TModel tmodel : tmodelList) {
                    col.add(ScoutUddiV3JaxrHelper.getConcept(tmodel, (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryV3Exception e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if (!"Service".equalsIgnoreCase(objectType)) throw new JAXRException("Unsupported type " + objectType + " for getRegistryObjects() in Apache Scout");
        try {
            ServiceDetail serviceDetail = registry.getServiceDetail(keys);
            if (serviceDetail == null) return new BulkResponseImpl(col);
            List bizServiceList = serviceDetail.getBusinessService();
            for (BusinessService businessService : bizServiceList) {
                Service service = this.getServiceFromBusinessService(businessService, (LifeCycleManager)lcm);
                col.add(service);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryV3Exception e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse getRegistryObjects(String id) throws JAXRException {
        if ("Organization".equalsIgnoreCase(id)) {
            IRegistryV3 registry = (IRegistryV3)this.registryService.getRegistry();
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            LinkedHashSet<Organization> orgs = null;
            try {
                RegisteredInfo ri = null;
                try {
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                catch (RegistryV3Exception rve) {
                    String username = this.getUsernameFromCredentials(con.getCredentials());
                    if (AuthTokenV3Singleton.getToken(username) != null) {
                        AuthTokenV3Singleton.deleteAuthToken(username);
                    }
                    auth = this.getAuthToken(con, registry);
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                if (ri != null && ri.getBusinessInfos() != null) {
                    List bizInfoList = ri.getBusinessInfos().getBusinessInfo();
                    orgs = new LinkedHashSet<Organization>();
                    for (BusinessInfo businessInfo : bizInfoList) {
                        BusinessDetail detail = registry.getBusinessDetail(businessInfo.getBusinessKey());
                        orgs.add(((BusinessLifeCycleManagerV3Impl)this.registryService.getLifeCycleManagerImpl()).createOrganization(detail));
                    }
                }
            }
            catch (RegistryV3Exception re) {
                throw new JAXRException((Throwable)re);
            }
            return new BulkResponseImpl(orgs);
        }
        if ("Service".equalsIgnoreCase(id)) {
            ArrayList<String> a = new ArrayList<String>();
            a.add("%");
            BulkResponse br = this.findServices(null, null, a, null, null);
            return br;
        }
        throw new JAXRException("Unsupported type for getRegistryObjects() :" + id);
    }

    static FindQualifiers mapFindQualifiers(Collection jaxrQualifiers) throws UnsupportedCapabilityException {
        FindQualifiers result = objectFactory.createFindQualifiers();
        boolean exact = false;
        if (jaxrQualifiers != null) {
            Iterator i = jaxrQualifiers.iterator();
            while (i.hasNext()) {
                String jaxrQualifier;
                String juddiQualifier = jaxrQualifier = (String)i.next();
                if ("exactNameMatch".equals(jaxrQualifier) || "exactMatch".equals(jaxrQualifier)) {
                    juddiQualifier = "exactMatch";
                    exact = true;
                }
                if (juddiQualifier == null) {
                    throw new UnsupportedCapabilityException("jUDDI does not support FindQualifer: " + jaxrQualifier);
                }
                result.getFindQualifier().add(juddiQualifier);
            }
        }
        if (!exact) {
            result.getFindQualifier().add("approximateMatch");
        }
        return result;
    }

    static Name[] mapNamePatterns(Collection namePatterns) throws JAXRException {
        if (namePatterns == null) {
            return null;
        }
        Name[] result = new Name[namePatterns.size()];
        int currLoc = 0;
        for (Object obj : namePatterns) {
            Name name = objectFactory.createName();
            if (obj instanceof String) {
                name.setValue((String)obj);
            } else if (obj instanceof LocalizedString) {
                LocalizedString ls = (LocalizedString)obj;
                name.setValue(ls.getValue());
                name.setLang(ls.getLocale().getLanguage());
            }
            result[currLoc] = name;
            ++currLoc;
        }
        return result;
    }

    private AuthToken getAuthToken(ConnectionImpl connection, IRegistryV3 ireg) throws JAXRException {
        Set creds = connection.getCredentials();
        Iterator it = creds.iterator();
        String username = "";
        String pwd = "";
        while (it.hasNext()) {
            PasswordAuthentication pass = (PasswordAuthentication)it.next();
            username = pass.getUserName();
            pwd = new String(pass.getPassword());
        }
        if (AuthTokenV3Singleton.getToken(username) != null) {
            return AuthTokenV3Singleton.getToken(username);
        }
        AuthToken token = null;
        try {
            token = ireg.getAuthToken(username, pwd);
        }
        catch (Exception e) {
            throw new JAXRException((Throwable)e);
        }
        AuthTokenV3Singleton.addAuthToken(username, token);
        return token;
    }

    private String getUsernameFromCredentials(Set credentials) {
        String username = "";
        String pwd = "";
        if (credentials != null) {
            for (PasswordAuthentication pass : credentials) {
                username = pass.getUserName();
            }
        }
        return username;
    }
}

