/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private final Log log = LogFactory.getLog(this.getClass());
    private InputStream inputStream = null;
    private URI baseURI;
    private String latestImportURI;

    public WSDLLocatorImpl(URI baseURI) {
        this.baseURI = baseURI;
    }

    public InputSource getBaseInputSource() {
        InputSource inputSource = null;
        try {
            this.inputStream = this.baseURI.toURL().openStream();
            inputSource = new InputSource(this.inputStream);
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return inputSource;
    }

    protected URL constructImportUrl(String parentLocation, String importLocation) {
        URL importUrl = null;
        try {
            URI importLocationURI = new URI(importLocation);
            if (importLocationURI.getScheme() != null || parentLocation == null) {
                importUrl = importLocationURI.toURL();
            } else {
                String parentDir = parentLocation.substring(0, parentLocation.lastIndexOf("/"));
                URI uri = new URI(parentDir + "/" + importLocation);
                importUrl = uri.normalize().toURL();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.log.debug((Object)("importUrl: " + importUrl.toExternalForm()));
        return importUrl;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        InputSource inputSource = null;
        try {
            URL importUrl = this.constructImportUrl(parentLocation, importLocation);
            InputStream inputStream = importUrl.openStream();
            inputSource = new InputSource(inputStream);
            this.latestImportURI = importUrl.toExternalForm();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return inputSource;
    }

    public String getBaseURI() {
        String baseURIStr = null;
        try {
            baseURIStr = this.baseURI.toURL().toExternalForm();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return baseURIStr;
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

