/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate3;

import org.jboss.as.jpa.JpaMessages;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class HibernatePatternFilter
implements VirtualFileFilter {
    private final String pattern;
    private final boolean exact;

    public HibernatePatternFilter(String pattern) {
        if (pattern == null) {
            throw JpaMessages.MESSAGES.nullVar("pattern");
        }
        this.exact = !pattern.contains("/");
        this.pattern = !this.exact && pattern.startsWith("**/*") ? pattern.substring(4) : pattern;
    }

    protected boolean accepts(String name) {
        return this.exact ? name.equals(this.pattern) : name.endsWith(this.pattern);
    }

    public boolean accepts(VirtualFile file) {
        String name = this.exact ? file.getName() : file.getPathName();
        return this.accepts(name);
    }
}

