/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class LoggingSubsystemProviders {
    static final String RESOURCE_NAME = LoggingSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("logging"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get("operations");
            subsystem.get(new String[]{"children", "root-logger", "description"}).set(bundle2.getString("root.logger"));
            subsystem.get(new String[]{"children", "root-logger", "model-description"}).setEmptyObject();
            subsystem.get(new String[]{"children", "logger", "description"}).set(bundle2.getString("logger"));
            subsystem.get(new String[]{"children", "async-handler", "description"}).set(bundle2.getString("async.handler"));
            subsystem.get(new String[]{"children", "console-handler", "description"}).set(bundle2.getString("console.handler"));
            subsystem.get(new String[]{"children", "file-handler", "description"}).set(bundle2.getString("file.handler"));
            subsystem.get(new String[]{"children", "periodic-rotating-file-handler", "description"}).set(bundle2.getString("periodic.handler"));
            subsystem.get(new String[]{"children", "size-rotating-file-handler", "description"}).set(bundle2.getString("size.periodic.handler"));
            subsystem.get(new String[]{"children", "custom-handler", "description"}).set(bundle2.getString("custom.handler"));
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("logging.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider SUBSYSTEM_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle2.getString("logging.remove"));
            op.get("reply-properties").setEmptyObject();
            op.get("request-properties").setEmptyObject();
            return op;
        }
    };
    static final DescriptionProvider ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("root.logger"));
            LoggingSubsystemProviders.addCommonLoggerAttributes(node, bundle2);
            return node;
        }
    };
    static final DescriptionProvider ADD_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle2.getString("root.logger.set"));
            LoggingSubsystemProviders.addCommonLoggerRequestProperties(node, bundle2);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider LEGACY_ADD_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("set-root-logger");
            node.get("description").set(bundle2.getString("root.logger.set"));
            LoggingSubsystemProviders.addCommonLoggerRequestProperties(node, bundle2);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider REMOVE_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("root.logger.remove"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider LEGACY_REMOVE_ROOT_LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove-root-logger");
            operation.get("description").set(bundle2.getString("root.logger.remove"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider ROOT_LOGGER_CHANGE_LEVEL = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("change-root-log-level");
            operation.get("description").set(bundle2.getString("root.logger.change-level"));
            CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "logger", operation);
            return operation;
        }
    };
    static final DescriptionProvider ROOT_LOGGER_ASSIGN_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("root-logger-assign-handler");
            node.get("description").set(bundle2.getString("root.logger.assign-handler"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", node);
            return node;
        }
    };
    static final DescriptionProvider ROOT_LOGGER_UNASSIGN_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("root-logger-unassign-handler");
            node.get("description").set(bundle2.getString("root.logger.unassign-handler"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", node);
            return node;
        }
    };
    static final DescriptionProvider LOGGER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("logger"));
            LoggingSubsystemProviders.addCommonLoggerAttributes(node, bundle2);
            CommonAttributes.USE_PARENT_HANDLERS.addResourceAttributeDescription(bundle2, "logger", node);
            CommonAttributes.CATEGORY.addResourceAttributeDescription(bundle2, "logger", node);
            return node;
        }
    };
    static final DescriptionProvider LOGGER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle2.getString("logger.add"));
            LoggingSubsystemProviders.addCommonLoggerRequestProperties(node, bundle2);
            CommonAttributes.USE_PARENT_HANDLERS.addOperationParameterDescription(bundle2, "logger", node);
            CommonAttributes.CATEGORY.addOperationParameterDescription(bundle2, "logger", node);
            return node;
        }
    };
    static final DescriptionProvider LOGGER_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(bundle2.getString("logger.remove"));
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };
    static final DescriptionProvider LOGGER_CHANGE_LEVEL = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("change-log-level");
            node.get("description").set(bundle2.getString("logger.change-level"));
            CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "logger", node);
            return node;
        }
    };
    static final DescriptionProvider LOGGER_ASSIGN_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("assign-handler");
            node.get("description").set(bundle2.getString("logger.assign-handler"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", node);
            return node;
        }
    };
    static final DescriptionProvider LOGGER_UNASSIGN_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("unassign-handler");
            node.get("description").set(bundle2.getString("logger.unassign-handler"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", node);
            return node;
        }
    };
    static final DescriptionProvider HANDLER_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(bundle2.getString("handler.remove"));
            return node;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("async.handler"));
            CommonAttributes.NAME.addResourceAttributeDescription(bundle2, "handler", node);
            CommonAttributes.LEVEL.addResourceAttributeDescription(bundle2, "handler", node);
            CommonAttributes.FILTER.addResourceAttributeDescription(bundle2, "handler", node);
            CommonAttributes.FORMATTER.addResourceAttributeDescription(bundle2, "handler", node);
            CommonAttributes.QUEUE_LENGTH.addResourceAttributeDescription(bundle2, "async", node);
            CommonAttributes.OVERFLOW_ACTION.addResourceAttributeDescription(bundle2, "async", node);
            CommonAttributes.SUBHANDLERS.addResourceAttributeDescription(bundle2, "async.handler", node);
            return node;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("async.handler.add"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.FILTER.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.FORMATTER.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.QUEUE_LENGTH.addOperationParameterDescription(bundle2, "async", operation);
            CommonAttributes.OVERFLOW_ACTION.addOperationParameterDescription(bundle2, "async", operation);
            CommonAttributes.SUBHANDLERS.addOperationParameterDescription(bundle2, "async.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle2.getString("async.handler.update"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.FILTER.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.FORMATTER.addOperationParameterDescription(bundle2, "handler", operation);
            CommonAttributes.QUEUE_LENGTH.addOperationParameterDescription(bundle2, "async", operation);
            CommonAttributes.OVERFLOW_ACTION.addOperationParameterDescription(bundle2, "async", operation);
            CommonAttributes.SUBHANDLERS.addOperationParameterDescription(bundle2, "async.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER_ASSIGN_SUBHANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("assign-subhandler");
            node.get("description").set(bundle2.getString("async.handler.assign-subhandler"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", node);
            return node;
        }
    };
    static final DescriptionProvider ASYNC_HANDLER_UNASSIGN_SUBHANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("unassign-subhandler");
            node.get("description").set(bundle2.getString("async.handler.unassign-subhandler"));
            CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", node);
            return node;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("console.handler"));
            LoggingSubsystemProviders.addCommonHandlerOutputStreamAttributes(node, bundle2);
            CommonAttributes.TARGET.addResourceAttributeDescription(bundle2, "console.handler", node);
            return node;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("console.handler"));
            LoggingSubsystemProviders.addCommonHandlerOutputStreamRequestProperties(operation, bundle2);
            CommonAttributes.TARGET.addOperationParameterDescription(bundle2, "console.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider CONSOLE_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle2.getString("console.handler.update"));
            LoggingSubsystemProviders.addCommonHandlerOutputStreamRequestProperties(operation, bundle2);
            CommonAttributes.TARGET.addOperationParameterDescription(bundle2, "console.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider FILE_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("file.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerAttributes(node, bundle2);
            return node;
        }
    };
    static final DescriptionProvider FILE_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("file.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle2);
            return operation;
        }
    };
    static final DescriptionProvider FILE_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle2.getString("file.handler.update"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle2);
            return operation;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("periodic.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerAttributes(node, bundle2);
            CommonAttributes.SUFFIX.addResourceAttributeDescription(bundle2, "periodic.handler", node);
            return node;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("periodic.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle2);
            CommonAttributes.SUFFIX.addOperationParameterDescription(bundle2, "periodic.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider PERIODIC_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle2.getString("periodic.handler.update"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle2);
            CommonAttributes.SUFFIX.addOperationParameterDescription(bundle2, "periodic.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("size.periodic.handler"));
            LoggingSubsystemProviders.addCommonFileHandlerAttributes(node, bundle2);
            CommonAttributes.ROTATE_SIZE.addResourceAttributeDescription(bundle2, "size.periodic.handler", node);
            CommonAttributes.MAX_BACKUP_INDEX.addResourceAttributeDescription(bundle2, "size.periodic.handler", node);
            return node;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("size.periodic.handler.add"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle2);
            CommonAttributes.ROTATE_SIZE.addOperationParameterDescription(bundle2, "size.periodic.handler", operation);
            CommonAttributes.MAX_BACKUP_INDEX.addOperationParameterDescription(bundle2, "size.periodic.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider SIZE_PERIODIC_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle2.getString("size.periodic.handler.update"));
            LoggingSubsystemProviders.addCommonFileHandlerRequestProperties(operation, bundle2);
            CommonAttributes.ROTATE_SIZE.addOperationParameterDescription(bundle2, "size.periodic.handler", operation);
            CommonAttributes.MAX_BACKUP_INDEX.addOperationParameterDescription(bundle2, "size.periodic.handler", operation);
            return operation;
        }
    };
    static final DescriptionProvider CUSTOM_HANDLER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle2.getString("custom.handler"));
            LoggingSubsystemProviders.addCommonHandlerAttributes(node, bundle2);
            CommonAttributes.CLASS.addResourceAttributeDescription(bundle2, "custom.handler", node);
            CommonAttributes.MODULE.addResourceAttributeDescription(bundle2, "custom.handler", node);
            LoggingSubsystemProviders.addHandlerPropertiesAttributes(node, bundle2);
            return node;
        }
    };
    static final DescriptionProvider CUSTOM_HANDLER_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle2.getString("custom.handler"));
            LoggingSubsystemProviders.addCommonHandlerRequestProperties(node, bundle2);
            CommonAttributes.CLASS.addOperationParameterDescription(bundle2, "custom.handler", node);
            CommonAttributes.MODULE.addOperationParameterDescription(bundle2, "custom.handler", node);
            LoggingSubsystemProviders.addHandlerPropertiesRequestProperties(node, bundle2);
            return node;
        }
    };
    static final DescriptionProvider CUSTOM_HANDLER_UPDATE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("update-properties");
            operation.get("description").set(bundle2.getString("custom.handler.update"));
            LoggingSubsystemProviders.addCommonHandlerRequestProperties(operation, bundle2);
            LoggingSubsystemProviders.addHandlerPropertiesRequestProperties(operation, bundle2);
            return operation;
        }
    };
    static final DescriptionProvider HANDLER_ENABLE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("enable");
            node.get("description").set(bundle2.getString("handler.enable"));
            return node;
        }
    };
    static final DescriptionProvider HANDLER_DISABLE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("disable");
            node.get("description").set(bundle2.getString("handler.disable"));
            return node;
        }
    };
    static final DescriptionProvider HANDLER_CHANGE_LEVEL = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("change-log-level");
            node.get("description").set(bundle2.getString("handler.change-level"));
            CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "logger", node);
            return node;
        }
    };
    static final DescriptionProvider HANDLER_CHANGE_FILE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = LoggingSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("change-file");
            node.get("description").set(bundle2.getString("handler.change-file"));
            ModelNode file = CommonAttributes.FILE.addOperationParameterDescription(bundle2, "file.handler", node);
            LoggingSubsystemProviders.addRequestPropertiesValueType(file, (AttributeDefinition)CommonAttributes.PATH, bundle2.getString("file.handler.path"));
            LoggingSubsystemProviders.addRequestPropertiesValueType(file, (AttributeDefinition)CommonAttributes.RELATIVE_TO, bundle2.getString("file.handler.relative-to"));
            return node;
        }
    };

    LoggingSubsystemProviders() {
    }

    private static void addCommonLoggerAttributes(ModelNode modelNode, ResourceBundle bundle2) {
        CommonAttributes.LEVEL.addResourceAttributeDescription(bundle2, "handler", modelNode);
        CommonAttributes.FILTER.addResourceAttributeDescription(bundle2, "handler", modelNode);
        CommonAttributes.HANDLERS.addResourceAttributeDescription(bundle2, "logger", modelNode);
    }

    private static void addCommonLoggerRequestProperties(ModelNode modelNode, ResourceBundle bundle2) {
        CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "handler", modelNode);
        CommonAttributes.FILTER.addOperationParameterDescription(bundle2, "handler", modelNode);
        CommonAttributes.HANDLERS.addOperationParameterDescription(bundle2, "logger", modelNode);
    }

    private static void addCommonHandlerAttributes(ModelNode modelNode, ResourceBundle bundle2) {
        CommonAttributes.NAME.addResourceAttributeDescription(bundle2, "handler", modelNode);
        CommonAttributes.ENCODING.addResourceAttributeDescription(bundle2, "handler", modelNode);
        CommonAttributes.LEVEL.addResourceAttributeDescription(bundle2, "handler", modelNode);
        CommonAttributes.FILTER.addResourceAttributeDescription(bundle2, "handler", modelNode);
        CommonAttributes.FORMATTER.addResourceAttributeDescription(bundle2, "handler", modelNode);
    }

    private static void addCommonHandlerRequestProperties(ModelNode modelNode, ResourceBundle bundle2) {
        CommonAttributes.NAME.addOperationParameterDescription(bundle2, "handler", modelNode);
        CommonAttributes.ENCODING.addOperationParameterDescription(bundle2, "handler", modelNode);
        CommonAttributes.LEVEL.addOperationParameterDescription(bundle2, "handler", modelNode);
        CommonAttributes.FILTER.addOperationParameterDescription(bundle2, "handler", modelNode);
        CommonAttributes.FORMATTER.addOperationParameterDescription(bundle2, "handler", modelNode);
    }

    private static void addCommonHandlerOutputStreamAttributes(ModelNode modelNode, ResourceBundle bundle2) {
        LoggingSubsystemProviders.addCommonHandlerAttributes(modelNode, bundle2);
        CommonAttributes.AUTOFLUSH.addResourceAttributeDescription(bundle2, "handler", modelNode);
    }

    private static void addCommonHandlerOutputStreamRequestProperties(ModelNode modelNode, ResourceBundle bundle2) {
        LoggingSubsystemProviders.addCommonHandlerRequestProperties(modelNode, bundle2);
        CommonAttributes.AUTOFLUSH.addOperationParameterDescription(bundle2, "handler", modelNode);
    }

    private static void addCommonFileHandlerAttributes(ModelNode model, ResourceBundle bundle2) {
        LoggingSubsystemProviders.addCommonHandlerOutputStreamAttributes(model, bundle2);
        CommonAttributes.APPEND.addResourceAttributeDescription(bundle2, "file.handler", model);
        ModelNode file = CommonAttributes.FILE.addResourceAttributeDescription(bundle2, "file.handler", model);
        LoggingSubsystemProviders.addAttributeValueType(file, (AttributeDefinition)CommonAttributes.PATH, bundle2.getString("file.handler.path"));
        LoggingSubsystemProviders.addAttributeValueType(file, (AttributeDefinition)CommonAttributes.RELATIVE_TO, bundle2.getString("file.handler.relative-to"));
    }

    private static void addCommonFileHandlerRequestProperties(ModelNode model, ResourceBundle bundle2) {
        LoggingSubsystemProviders.addCommonHandlerOutputStreamRequestProperties(model, bundle2);
        CommonAttributes.APPEND.addOperationParameterDescription(bundle2, "file.handler", model);
        ModelNode file = CommonAttributes.FILE.addOperationParameterDescription(bundle2, "file.handler", model);
        LoggingSubsystemProviders.addRequestPropertiesValueType(file, (AttributeDefinition)CommonAttributes.PATH, bundle2.getString("file.handler.path"));
        LoggingSubsystemProviders.addRequestPropertiesValueType(file, (AttributeDefinition)CommonAttributes.RELATIVE_TO, bundle2.getString("file.handler.relative-to"));
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static ModelNode addAttributeValueType(ModelNode node, AttributeDefinition definition, String description) {
        ModelNode valueType = node.get(new String[]{"value-type", definition.getName()});
        valueType.get("description").set(description);
        valueType.get("type").set(definition.getType());
        return valueType;
    }

    private static ModelNode addRequestPropertiesValueType(ModelNode node, AttributeDefinition definition, String description) {
        ModelNode valueType = node.get(new String[]{"value-type", definition.getName()});
        valueType.get("description").set(description);
        valueType.get("type").set(definition.getType());
        valueType.get("required").set(!definition.isAllowNull());
        return valueType;
    }

    private static ModelNode addHandlerPropertiesAttributes(ModelNode node, ResourceBundle bundle2) {
        ModelNode property = node.get(new String[]{"attributes", "properties"});
        property.get("type").set(ModelType.LIST);
        property.get("description").set(bundle2.getString("handler.properties"));
        LoggingSubsystemProviders.addAttributeValueType(property, (AttributeDefinition)CommonAttributes.NAME, bundle2.getString("handler.properties.name"));
        LoggingSubsystemProviders.addAttributeValueType(property, (AttributeDefinition)CommonAttributes.VALUE, bundle2.getString("handler.properties.value"));
        return property;
    }

    private static ModelNode addHandlerPropertiesRequestProperties(ModelNode node, ResourceBundle bundle2) {
        ModelNode property = node.get(new String[]{"request-properties", "properties"});
        property.get("type").set(ModelType.LIST);
        property.get("description").set(bundle2.getString("handler.properties"));
        LoggingSubsystemProviders.addRequestPropertiesValueType(property, (AttributeDefinition)CommonAttributes.NAME, bundle2.getString("handler.properties.name"));
        LoggingSubsystemProviders.addRequestPropertiesValueType(property, (AttributeDefinition)CommonAttributes.VALUE, bundle2.getString("handler.properties.value"));
        return property;
    }
}

