/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.FlushingHandlerAddProperties;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.as.logging.handlers.file.SizeRotatingFileHandlerService;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;

public class SizeRotatingFileHandlerAdd
extends FlushingHandlerAddProperties<SizeRotatingFileHandlerService> {
    public static final SizeRotatingFileHandlerAdd INSTANCE = new SizeRotatingFileHandlerAdd();

    private SizeRotatingFileHandlerAdd() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.FILE, CommonAttributes.MAX_BACKUP_INDEX, CommonAttributes.ROTATE_SIZE});
    }

    @Override
    protected SizeRotatingFileHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SizeRotatingFileHandlerService();
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, SizeRotatingFileHandlerService service, ModelNode model) throws OperationFailedException {
        ModelNode rotateSizeNode;
        ModelNode maxBackupIndex;
        ModelNode file;
        super.updateRuntime(context, serviceBuilder, name, service, model);
        ModelNode append = CommonAttributes.APPEND.resolveModelAttribute(context, model);
        if (append.isDefined()) {
            service.setAppend(append.asBoolean());
        }
        if ((file = CommonAttributes.FILE.resolveModelAttribute(context, model)).isDefined()) {
            FileHandlers.addFile(context, serviceBuilder, service, file, name);
        }
        if ((maxBackupIndex = CommonAttributes.MAX_BACKUP_INDEX.resolveModelAttribute(context, model)).isDefined()) {
            service.setMaxBackupIndex(maxBackupIndex.asInt());
        }
        if ((rotateSizeNode = CommonAttributes.ROTATE_SIZE.resolveModelAttribute(context, model)).isDefined()) {
            service.setRotateSize(ModelParser.parseSize(rotateSizeNode));
        }
    }
}

