/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.logging.Logger;
import org.hornetq.spi.core.remoting.BufferDecoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class HornetQFrameDecoder
extends FrameDecoder {
    private static final Logger log = Logger.getLogger(HornetQFrameDecoder.class);
    private final BufferDecoder decoder;

    public HornetQFrameDecoder(BufferDecoder decoder) {
        this.decoder = decoder;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) throws Exception {
        int start = in.readerIndex();
        int length = this.decoder.isReadyToHandle(new ChannelBufferWrapper(in));
        in.readerIndex(start);
        if (length == -1) {
            return null;
        }
        ChannelBuffer buffer = in.readBytes(length);
        ChannelBuffer newBuffer = ChannelBuffers.dynamicBuffer(buffer.writerIndex());
        newBuffer.writeBytes(buffer);
        return newBuffer;
    }
}

