/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;

class VersionReceiver
implements Channel.Receiver {
    private static final Logger logger = Logger.getLogger(VersionReceiver.class);
    private final byte clientVersion;
    private final String clientMarshallingStrategy;
    private final CountDownLatch latch;
    private Channel compatibleChannel;

    VersionReceiver(CountDownLatch latch, byte clientVersion, String marshallingStrategy) {
        this.clientVersion = clientVersion;
        this.clientMarshallingStrategy = marshallingStrategy;
        this.latch = latch;
    }

    @Override
    public void handleError(Channel channel, IOException error) {
        logger.error((Object)("Error on channel " + channel), error);
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleEnd(Channel channel) {
        logger.info("Channel end notification received. No more communication will happen on channel " + channel);
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleMessage(Channel channel, MessageInputStream message) {
        Object[] serverMarshallerStrategies;
        byte serverVersion;
        SimpleDataInput simpleDataInput = new SimpleDataInput(Marshalling.createByteInput(message));
        try {
            serverVersion = simpleDataInput.readByte();
            int serverMarshallerCount = PackedInteger.readPackedInteger(simpleDataInput);
            if (serverMarshallerCount <= 0) {
                throw new RuntimeException("Client cannot communicate with the server since no marshalling strategy has been configured on server side");
            }
            serverMarshallerStrategies = new String[serverMarshallerCount];
            for (int i = 0; i < serverMarshallerCount; ++i) {
                serverMarshallerStrategies[i] = simpleDataInput.readUTF();
            }
            logger.info("Received server version " + serverVersion + " and marshalling strategies " + Arrays.toString(serverMarshallerStrategies));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.checkCompatibility(serverVersion, (String[])serverMarshallerStrategies)) {
            logger.error("EJB receiver cannot communicate with server, due to version incompatibility");
            return;
        }
        try {
            this.sendVersionMessage(channel);
            this.compatibleChannel = channel;
            this.latch.countDown();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    Channel getCompatibleChannel() {
        return this.compatibleChannel;
    }

    private boolean checkCompatibility(byte serverVersion, String[] serverMarshallingStrategies) {
        if (serverVersion < this.clientVersion) {
            return false;
        }
        List<String> supportedStrategies = Arrays.asList(serverMarshallingStrategies);
        return supportedStrategies.contains(this.clientMarshallingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVersionMessage(Channel channel) throws IOException {
        MessageOutputStream channelOutputStream = channel.writeMessage();
        DataOutputStream dataOutputStream = new DataOutputStream(channelOutputStream);
        try {
            dataOutputStream.write(this.clientVersion);
            dataOutputStream.writeUTF(this.clientMarshallingStrategy);
        }
        finally {
            dataOutputStream.close();
            channelOutputStream.close();
        }
    }
}

