/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.metadata.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.IMetadataConfigurationStore;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLMetadataWriter;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedMetadataConfigurationStore
implements IMetadataConfigurationStore {
    private static Logger log = Logger.getLogger(FileBasedMetadataConfigurationStore.class);
    private final boolean trace = log.isTraceEnabled();
    private String userHome = null;
    private String baseDirectory = null;

    public FileBasedMetadataConfigurationStore() {
        this.bootstrap();
    }

    @Override
    public void bootstrap() {
        this.userHome = SecurityActions.getSystemProperty("user.home");
        if (this.userHome == null) {
            throw new RuntimeException("PL00087: System Property missing:user.home");
        }
        StringBuilder builder = new StringBuilder(this.userHome);
        builder.append("/picketlink-store");
        this.baseDirectory = builder.toString();
        File plStore = new File(this.baseDirectory);
        if (!plStore.exists()) {
            if (this.trace) {
                log.trace((Object)(String.valueOf(plStore.getPath()) + " does not exist. Hence creating."));
            }
            plStore.mkdir();
        }
    }

    @Override
    public Set<String> getIdentityProviderID() {
        HashSet<String> identityProviders = new HashSet<String>();
        Properties idp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/identityproviders.properties");
        File identityProviderFile = new File(builder.toString());
        if (identityProviderFile.exists()) {
            try {
                idp.load(new FileInputStream(identityProviderFile));
                String listOfIDP = (String)idp.get("IDP");
                if (StringUtil.isNotNull(listOfIDP)) {
                    identityProviders.addAll(StringUtil.tokenize(listOfIDP));
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception loading the identity providers:", (Throwable)e);
            }
        }
        return identityProviders;
    }

    @Override
    public Set<String> getServiceProviderID() {
        HashSet<String> serviceProviders = new HashSet<String>();
        Properties sp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/serviceproviders.properties");
        File serviceProviderFile = new File(builder.toString());
        if (serviceProviderFile.exists()) {
            try {
                sp.load(new FileInputStream(serviceProviderFile));
                String listOfSP = (String)sp.get("SP");
                StringTokenizer st = new StringTokenizer(listOfSP, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    serviceProviders.add(token);
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception loading the service providers:", (Throwable)e);
            }
        }
        return serviceProviders;
    }

    @Override
    public EntityDescriptorType load(String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        SAMLEntityDescriptorParser parser = new SAMLEntityDescriptorParser();
        try {
            return (EntityDescriptorType)parser.parse(StaxParserUtil.getXMLEventReader(new FileInputStream(persistedFile)));
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void persist(EntityDescriptorType entity, String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        try {
            XMLStreamWriter streamWriter = StaxUtil.getXMLStreamWriter(new FileOutputStream(persistedFile));
            SAMLMetadataWriter writer = new SAMLMetadataWriter(streamWriter);
            writer.writeEntityDescriptor(entity);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        if (this.trace) {
            log.trace((Object)("Persisted into " + persistedFile.getPath()));
        }
        List<EntityDescriptorType.EDTChoiceType> edtChoiceTypeList = entity.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edtChoiceType : edtChoiceTypeList) {
            List<EntityDescriptorType.EDTDescriptorChoiceType> edtDescriptorChoiceTypeList = edtChoiceType.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptorChoiceTypeList) {
                SPSSODescriptorType spSSO;
                IDPSSODescriptorType idpSSO = edtDesc.getIdpDescriptor();
                if (idpSSO != null) {
                    this.addIdentityProvider(id);
                }
                if ((spSSO = edtDesc.getSpDescriptor()) == null) continue;
                this.addServiceProvider(id);
            }
        }
    }

    @Override
    public void delete(String id) {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    @Override
    public Map<String, String> loadTrustedProviders(String id) throws IOException, ClassNotFoundException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectInputStream ois = null;
        try {
            Map trustedMap;
            ois = new ObjectInputStream(new FileInputStream(trustedFile));
            Map map = trustedMap = (Map)ois.readObject();
            return map;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    @Override
    public void persistTrustedProviders(String id, Map<String, String> trusted) throws IOException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(trustedFile));
            oos.writeObject(trusted);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        if (this.trace) {
            log.trace((Object)("Persisted trusted map into " + trustedFile.getPath()));
        }
    }

    @Override
    public void deleteTrustedProviders(String id) {
        File persistedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    private File validateIdAndReturnMDFile(String id) {
        String serializationExtension = ".SER";
        if (id == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:id");
        }
        if (!id.endsWith(serializationExtension)) {
            id = String.valueOf(id) + serializationExtension;
        }
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/").append(id);
        return new File(builder.toString());
    }

    private File validateIdAndReturnTrustedProvidersFile(String id) {
        if (id == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:id");
        }
        id = String.valueOf(id) + "-trusted.SER";
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/").append(id);
        return new File(builder.toString());
    }

    private void addServiceProvider(String id) {
        Properties sp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/serviceproviders.properties");
        File serviceProviderFile = new File(builder.toString());
        try {
            if (!serviceProviderFile.exists()) {
                serviceProviderFile.createNewFile();
            }
            sp.load(new FileInputStream(serviceProviderFile));
            String listOfSP = (String)sp.get("SP");
            listOfSP = listOfSP == null ? id : String.valueOf(listOfSP) + "," + id;
            sp.put("SP", listOfSP);
            sp.store(new FileWriter(serviceProviderFile), "");
        }
        catch (Exception e) {
            log.error((Object)"Exception loading the service providers:", (Throwable)e);
        }
    }

    private void addIdentityProvider(String id) {
        Properties idp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/identityproviders.properties");
        File idpProviderFile = new File(builder.toString());
        try {
            if (!idpProviderFile.exists()) {
                idpProviderFile.createNewFile();
            }
            idp.load(new FileInputStream(idpProviderFile));
            String listOfIDP = (String)idp.get("IDP");
            listOfIDP = listOfIDP == null ? id : String.valueOf(listOfIDP) + "," + id;
            idp.put("IDP", listOfIDP);
            idp.store(new FileWriter(idpProviderFile), "");
        }
        catch (Exception e) {
            log.error((Object)"Exception loading the identity providers:", (Throwable)e);
        }
    }

    @Override
    public void cleanup() {
    }
}

