/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.sts.registry.FileBasedSTSOperations;
import org.picketlink.identity.federation.core.sts.registry.RevocationRegistry;

public class FileBasedRevocationRegistry
extends FileBasedSTSOperations
implements RevocationRegistry {
    private static Logger logger = Logger.getLogger(FileBasedRevocationRegistry.class);
    protected static final String FILE_NAME = "revoked.ids";
    protected static Set<String> revokedIds = new HashSet<String>();
    protected File registryFile;

    public FileBasedRevocationRegistry() {
        this(FILE_NAME);
    }

    public FileBasedRevocationRegistry(String registryFileName) {
        this.registryFile = this.create(registryFileName);
        this.loadRevokedIds();
    }

    public boolean isRevoked(String tokenType, String id) {
        return revokedIds.contains(id);
    }

    public synchronized void revokeToken(String tokenType, String id) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.registryFile, true));
            writer.write(String.valueOf(id) + "\n");
            writer.close();
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error appending content to registry file: " + ioe.getMessage()));
            }
            ioe.printStackTrace();
        }
        revokedIds.add(id);
    }

    private void loadRevokedIds() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.registryFile));
            String id = reader.readLine();
            while (id != null) {
                revokedIds.add(id);
                id = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening registry file: " + ioe.getMessage()));
            }
            ioe.printStackTrace();
        }
    }
}

